/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.geode.management.membership.ClientMembershipListenerAdapter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionShortcutWrapper;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.tests.integration.config.ClientServerIntegrationTestsConfiguration;
import org.springframework.data.gemfire.tests.util.ObjectUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Deprecated
public class SubscriptionEnabledClientServerIntegrationTestsConfiguration
extends ClientServerIntegrationTestsConfiguration {
    private static final boolean DEFAULT_SUBSCRIPTION_QUEUE_CONNECTION_FAILURE = true;
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final CountDownLatch LATCH = new CountDownLatch(1);
    private static final String GEMFIRE_CACHE_SERVER_PORT_PROPERTY = "spring.data.gemfire.cache.server.port";
    private static final String SPRING_DATA_GEODE_POOL_NAME = "gemfirePool";
    private static final String GEMFIRE_DEFAULT_POOL_NAME = "DEFAULT";
    private static final String LOCALHOST = "localhost";

    protected Long getSocketConnectTimeout() {
        return this.resolveTimeout() / 2L;
    }

    protected Long getTimeout() {
        return DEFAULT_TIMEOUT;
    }

    protected boolean isThrowExceptionOnSubscriptionQueueConnectionFailure() {
        return true;
    }

    private long resolveSocketConnectTimeout() {
        Long socketConnectTimeout = this.getSocketConnectTimeout();
        long resolvedTimeout = this.resolveTimeout();
        long resolvedSocketConnectTimeout = socketConnectTimeout != null ? socketConnectTimeout : resolvedTimeout;
        return Math.min(Math.max(resolvedSocketConnectTimeout, 0L), resolvedTimeout / 2L);
    }

    private long resolveTimeout() {
        Long timeout = this.getTimeout();
        return Math.max(timeout != null ? timeout : DEFAULT_TIMEOUT, 0L);
    }

    @Bean
    @Conditional(value={ClientCacheFactoryBeanSetSocketConnectTimeoutPresentCondition.class})
    BeanPostProcessor clientCachePoolSocketConnectTimeoutBeanPostProcessor() {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ClientCacheFactoryBean) {
                    ((ClientCacheFactoryBean)bean).setSocketConnectTimeout(Integer.valueOf(Long.valueOf(SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.resolveSocketConnectTimeout()).intValue()));
                } else if (bean instanceof PoolFactoryBean) {
                    ((PoolFactoryBean)bean).setSocketConnectTimeout(Long.valueOf(SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.resolveSocketConnectTimeout()).intValue());
                }
                return bean;
            }
        };
    }

    @Bean
    BeanPostProcessor clientServerReadyBeanPostProcessor(final ListableBeanFactory beanFactory, final @Value(value="${spring.data.gemfire.cache.server.port:40404}") int port) {
        return new BeanPostProcessor(){
            private final AtomicBoolean verifyGemFireServerIsRunning = new AtomicBoolean(true);

            @Nullable
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (this.isGemFireServerRunningVerificationEnabled(bean, beanName)) {
                    try {
                        this.verifyClientCacheMemberJoined();
                        this.verifyClientCacheSubscriptionQueueConnectionsEstablished();
                    }
                    catch (InterruptedException cause) {
                        Thread.currentThread().interrupt();
                    }
                }
                return bean;
            }

            private boolean isGemFireServerRunningVerificationEnabled(Object bean, String beanName) {
                return this.isVeryImportantBean(bean, beanName) && this.verifyGemFireServerIsRunning.compareAndSet(true, false);
            }

            private boolean isVeryImportantBean(Object bean, String beanName) {
                return this.isContinuousQueryListenerContainer(bean) || this.isClientProxyRegion(bean);
            }

            private boolean isContinuousQueryListenerContainer(Object bean) {
                return bean instanceof ContinuousQueryListenerContainer;
            }

            private boolean isClientProxyRegion(Object bean) {
                if (bean instanceof ClientRegionFactoryBean) {
                    ClientRegionFactoryBean clientRegionFactoryBean = (ClientRegionFactoryBean)bean;
                    return clientRegionFactoryBean.getPoolName().filter(StringUtils::hasText).map(it -> true).orElseGet(() -> this.resolveClientRegionShortcut(clientRegionFactoryBean).map(ClientRegionShortcutWrapper::valueOf).filter(ClientRegionShortcutWrapper::isProxy).isPresent());
                }
                return false;
            }

            private Optional<ClientRegionShortcut> resolveClientRegionShortcut(ClientRegionFactoryBean<?, ?> clientRegionFactoryBean) {
                try {
                    Method resolveClientRegionShortcut = ClientRegionFactoryBean.class.getDeclaredMethod("resolveClientRegionShortcut", new Class[0]);
                    resolveClientRegionShortcut.setAccessible(true);
                    return Optional.ofNullable((ClientRegionShortcut)ReflectionUtils.invokeMethod((Method)resolveClientRegionShortcut, clientRegionFactoryBean));
                }
                catch (Throwable ignore) {
                    return Optional.empty();
                }
            }

            private void verifyClientCacheMemberJoined() throws InterruptedException {
                String errorMessage = String.format("CacheServer failed to start on host [%s] and port [%d]", SubscriptionEnabledClientServerIntegrationTestsConfiguration.LOCALHOST, port);
                Assert.state((boolean)LATCH.await(SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.resolveTimeout(), TimeUnit.MILLISECONDS), (String)errorMessage);
            }

            private void verifyClientCacheSubscriptionQueueConnectionsEstablished() {
                this.resolvePools().stream().filter(pool -> pool.getSubscriptionEnabled()).filter(pool -> pool instanceof PoolImpl).map(pool -> (PoolImpl)pool).forEach(pool -> {
                    long timeout = System.currentTimeMillis() + SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.resolveTimeout();
                    while (System.currentTimeMillis() < timeout && !pool.isPrimaryUpdaterAlive()) {
                        PoolImpl poolImpl = pool;
                        synchronized (poolImpl) {
                            ObjectUtils.doOperationSafely(() -> {
                                TimeUnit.MILLISECONDS.timedWait(pool, 500L);
                                return null;
                            });
                        }
                    }
                    String errorMessage = String.format("ClientCache subscription queue connection not established; Pool [%s] has configuration [locators = %s, servers = %s]", pool, pool.getLocators(), pool.getServers());
                    if (SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.isThrowExceptionOnSubscriptionQueueConnectionFailure()) {
                        Assert.state((boolean)pool.isPrimaryUpdaterAlive(), (String)errorMessage);
                    } else if (SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.getLogger().isWarnEnabled()) {
                        SubscriptionEnabledClientServerIntegrationTestsConfiguration.this.getLogger().warn(errorMessage);
                    }
                });
            }

            private Collection<Pool> resolvePools() {
                this.eagerlyInitializeSpringManagedPoolBeans();
                return CollectionUtils.nullSafeMap((Map)PoolManager.getAll()).values();
            }

            private void eagerlyInitializeSpringManagedPoolBeans() {
                beanFactory.getBeansOfType(PoolFactoryBean.class).keySet().forEach(beanName -> {
                    Pool cfr_ignored_0 = (Pool)beanFactory.getBean(beanName, Pool.class);
                });
            }
        };
    }

    @PostConstruct
    public void registerClientMembershipListener() {
        ClientMembership.registerClientMembershipListener((ClientMembershipListener)new ClientMembershipListenerAdapter(){

            public void memberJoined(ClientMembershipEvent event) {
                LATCH.countDown();
            }
        });
    }

    public static class ClientCacheFactoryBeanSetSocketConnectTimeoutPresentCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return Arrays.stream(ArrayUtils.nullSafeArray((Object[])ClientCacheFactoryBean.class.getMethods(), Method.class)).map(Method::getName).anyMatch("setSocketConnectTimeout"::equals);
        }
    }
}

