/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.util.CollectionUtils;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.data.gemfire.util.RegionUtils;

public abstract class CacheMockObjects {
    public static <T extends GemFireCache> T mockGemFireCache(T mockGemFireCache, String name, DistributedSystem distributedSystem, ResourceManager resourceManager, Region<?, ?> ... regions) {
        GemFireCache theMockGemFireCache = mockGemFireCache != null ? mockGemFireCache : (GemFireCache)Mockito.mock(GemFireCache.class, (MockSettings)Mockito.withSettings().name(name).lenient());
        Mockito.when((Object)theMockGemFireCache.getDistributedSystem()).thenReturn((Object)distributedSystem);
        Mockito.when((Object)theMockGemFireCache.getName()).thenReturn((Object)name);
        Mockito.when((Object)theMockGemFireCache.getResourceManager()).thenReturn((Object)resourceManager);
        Optional.ofNullable(regions).filter(it -> ((Region[])it).length != 0).ifPresent(it -> Mockito.when((Object)theMockGemFireCache.rootRegions()).thenReturn((Object)CollectionUtils.asSet((Object[])it)));
        return theMockGemFireCache;
    }

    public static ClientCache mockClientCache(String name, DistributedSystem distributedSystem, ResourceManager resourceManager, Region<?, ?> ... regions) {
        return (ClientCache)CacheMockObjects.mockGemFireCache((GemFireCache)Mockito.mock(ClientCache.class, (MockSettings)Mockito.withSettings().name(name).lenient()), name, distributedSystem, resourceManager, regions);
    }

    public static Cache mockPeerCache(String name, DistributedSystem distributedSystem, ResourceManager resourceManager, Region<?, ?> ... regions) {
        return (Cache)CacheMockObjects.mockGemFireCache((GemFireCache)Mockito.mock(Cache.class, (MockSettings)Mockito.withSettings().name(name).lenient()), name, distributedSystem, resourceManager, regions);
    }

    public static DistributedSystem mockDistributedSystem(DistributedMember distributedMember) {
        DistributedSystem mockDistributedSystem = (DistributedSystem)Mockito.mock(DistributedSystem.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockDistributedSystem.getDistributedMember()).thenReturn((Object)distributedMember);
        return mockDistributedSystem;
    }

    public static DistributedMember mockDistributedMember(String name, String ... groups) {
        DistributedMember mockDistributeMember = (DistributedMember)Mockito.mock(DistributedMember.class, (MockSettings)Mockito.withSettings().name(name).lenient());
        Mockito.when((Object)mockDistributeMember.getName()).thenReturn((Object)name);
        Mockito.when((Object)mockDistributeMember.getGroups()).thenReturn(Arrays.asList(groups));
        Mockito.when((Object)mockDistributeMember.getId()).thenReturn((Object)UUID.randomUUID().toString());
        return mockDistributeMember;
    }

    public static ResourceManager mockResourceManager(float criticalHeapPercentage, float criticalOffHeapPercentage, float evictionHeapPercentage, float evictionOffHeapPercentage) {
        ResourceManager mockResourceManager = (ResourceManager)Mockito.mock(ResourceManager.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)Float.valueOf(mockResourceManager.getCriticalHeapPercentage())).thenReturn((Object)Float.valueOf(criticalHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getCriticalOffHeapPercentage())).thenReturn((Object)Float.valueOf(criticalOffHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getEvictionHeapPercentage())).thenReturn((Object)Float.valueOf(evictionHeapPercentage));
        Mockito.when((Object)Float.valueOf(mockResourceManager.getEvictionOffHeapPercentage())).thenReturn((Object)Float.valueOf(evictionOffHeapPercentage));
        return mockResourceManager;
    }

    public static <K, V> Region<K, V> mockRegion(String name, DataPolicy dataPolicy) {
        Region mockRegion = (Region)Mockito.mock(Region.class, (MockSettings)Mockito.withSettings().name(name).lenient());
        Mockito.when((Object)mockRegion.getName()).thenReturn((Object)RegionUtils.toRegionName((String)name));
        Mockito.when((Object)mockRegion.getFullPath()).thenReturn((Object)RegionUtils.toRegionPath((String)name));
        RegionAttributes mockRegionAttributes = (RegionAttributes)Mockito.mock(RegionAttributes.class, (MockSettings)Mockito.withSettings().name(String.format("%sRegionAttributes", name)).lenient());
        Mockito.when((Object)mockRegionAttributes.getDataPolicy()).thenReturn((Object)dataPolicy);
        Mockito.when((Object)mockRegion.getAttributes()).thenReturn((Object)mockRegionAttributes);
        return mockRegion;
    }
}

