/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.data.gemfire.tests.mock.MockObjectsSupport;

public abstract class GatewayMockObjects
extends MockObjectsSupport {
    public static GatewayReceiver mockGatewayReceiver(String bindAddress, int endPort, String host, String hostnameForSenders, boolean manualStart, int maxTimeBetweenPings, int port, boolean initialRunningState, CacheServer server, int socketBufferSize, int startPort) throws IOException {
        AtomicBoolean running = new AtomicBoolean(initialRunningState);
        GatewayReceiver mockGatewayReceiver = (GatewayReceiver)Mockito.mock(GatewayReceiver.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockGatewayReceiver.getBindAddress()).thenReturn((Object)bindAddress);
        Mockito.when((Object)mockGatewayReceiver.getEndPort()).thenReturn((Object)endPort);
        Mockito.when((Object)mockGatewayReceiver.getHost()).thenReturn((Object)host);
        Mockito.when((Object)mockGatewayReceiver.isManualStart()).thenReturn((Object)manualStart);
        Mockito.when((Object)mockGatewayReceiver.getMaximumTimeBetweenPings()).thenReturn((Object)maxTimeBetweenPings);
        Mockito.when((Object)mockGatewayReceiver.getPort()).thenReturn((Object)port);
        Mockito.when((Object)mockGatewayReceiver.isRunning()).thenAnswer(GatewayMockObjects.newGetter(running));
        Mockito.when((Object)mockGatewayReceiver.getServer()).thenReturn((Object)server);
        Mockito.when((Object)mockGatewayReceiver.getSocketBufferSize()).thenReturn((Object)socketBufferSize);
        Mockito.when((Object)mockGatewayReceiver.getStartPort()).thenReturn((Object)startPort);
        ((GatewayReceiver)Mockito.doAnswer(GatewayMockObjects.newSetter(running, Boolean.valueOf(true))).when((Object)mockGatewayReceiver)).start();
        ((GatewayReceiver)Mockito.doAnswer(GatewayMockObjects.newSetter(running, Boolean.valueOf(false))).when((Object)mockGatewayReceiver)).stop();
        return mockGatewayReceiver;
    }

    public static GatewaySender mockGatewaySender(String id, int alertThreshold, boolean batchConflationEnabled, int batchSize, int batchTimeInterval, String diskStoreName, boolean diskSynchronous, int dispatcherThreads, int maxQueueMemory, int maxParallelismForReplicatedRegion, GatewaySender.OrderPolicy orderPolicy, boolean parallel, boolean persistent, int remoteDistributedSystemId, boolean initialRunningState, int socketBufferSize, int socketReadTimeout) {
        AtomicBoolean paused = new AtomicBoolean(false);
        AtomicBoolean running = new AtomicBoolean(initialRunningState);
        AtomicBoolean runningState = new AtomicBoolean(running.get());
        GatewaySender mockGatewaySender = (GatewaySender)Mockito.mock(GatewaySender.class, (MockSettings)Mockito.withSettings().name(id).lenient());
        Mockito.when((Object)mockGatewaySender.getAlertThreshold()).thenReturn((Object)alertThreshold);
        Mockito.when((Object)mockGatewaySender.isBatchConflationEnabled()).thenReturn((Object)batchConflationEnabled);
        Mockito.when((Object)mockGatewaySender.getBatchSize()).thenReturn((Object)batchSize);
        Mockito.when((Object)mockGatewaySender.getBatchTimeInterval()).thenReturn((Object)batchTimeInterval);
        Mockito.when((Object)mockGatewaySender.getDiskStoreName()).thenReturn((Object)diskStoreName);
        Mockito.when((Object)mockGatewaySender.isDiskSynchronous()).thenReturn((Object)diskSynchronous);
        Mockito.when((Object)mockGatewaySender.getDispatcherThreads()).thenReturn((Object)dispatcherThreads);
        Mockito.when((Object)mockGatewaySender.getId()).thenReturn((Object)id);
        Mockito.when((Object)mockGatewaySender.getMaximumQueueMemory()).thenReturn((Object)maxQueueMemory);
        Mockito.when((Object)mockGatewaySender.getMaxParallelismForReplicatedRegion()).thenReturn((Object)maxParallelismForReplicatedRegion);
        Mockito.when((Object)mockGatewaySender.getOrderPolicy()).thenReturn((Object)orderPolicy);
        Mockito.when((Object)mockGatewaySender.isParallel()).thenReturn((Object)parallel);
        Mockito.when((Object)mockGatewaySender.isPaused()).thenAnswer(GatewayMockObjects.newGetter(paused));
        Mockito.when((Object)mockGatewaySender.isPersistenceEnabled()).thenReturn((Object)persistent);
        Mockito.when((Object)mockGatewaySender.isRunning()).thenAnswer(GatewayMockObjects.newGetter(running));
        Mockito.when((Object)mockGatewaySender.getRemoteDSId()).thenReturn((Object)remoteDistributedSystemId);
        Mockito.when((Object)mockGatewaySender.getSocketBufferSize()).thenReturn((Object)socketBufferSize);
        Mockito.when((Object)mockGatewaySender.getSocketReadTimeout()).thenReturn((Object)socketReadTimeout);
        ((GatewaySender)Mockito.doAnswer(invocation -> {
            paused.set(true);
            running.set(false);
            return null;
        }).when((Object)mockGatewaySender)).pause();
        ((GatewaySender)Mockito.doAnswer(invocation -> {
            paused.set(false);
            running.set(runningState.get());
            return null;
        }).when((Object)mockGatewaySender)).resume();
        ((GatewaySender)Mockito.doAnswer(invocation -> {
            running.set(true);
            runningState.set(true);
            return null;
        }).when((Object)mockGatewaySender)).start();
        ((GatewaySender)Mockito.doAnswer(invocation -> {
            running.set(false);
            runningState.set(false);
            return null;
        }).when((Object)mockGatewaySender)).stop();
        return mockGatewaySender;
    }
}

