/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.data.gemfire.tests.mock.annotation.EnableGemFireMockObjects;
import org.springframework.data.gemfire.tests.mock.config.GemFireMockObjectsBeanPostProcessor;

@Configuration
public class GemFireMockObjectsConfiguration
implements ApplicationListener<ContextClosedEvent>,
ImportAware {
    private boolean useSingletonCache = false;

    public void setImportMetadata(AnnotationMetadata importingClassMetadata) {
        Optional.of(importingClassMetadata).filter(this::isAnnotationPresent).map(this::getAnnotationAttributes).ifPresent(enableGemFireMockObjectsAttributes -> {
            this.useSingletonCache = enableGemFireMockObjectsAttributes.getBoolean("useSingletonCache");
        });
    }

    private Class<? extends Annotation> getAnnotationType() {
        return EnableGemFireMockObjects.class;
    }

    private boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata) {
        return this.isAnnotationPresent(importingClassMetadata, this.getAnnotationType());
    }

    private boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> annotationType) {
        return importingClassMetadata.hasAnnotation(annotationType.getName());
    }

    private AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata) {
        return this.getAnnotationAttributes(importingClassMetadata, this.getAnnotationType());
    }

    private AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> annotationType) {
        return AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(annotationType.getName()));
    }

    @Bean
    public BeanPostProcessor gemfireMockObjectsBeanPostProcessor() {
        return GemFireMockObjectsBeanPostProcessor.newInstance(this.useSingletonCache);
    }

    @EventListener
    public void releaseMockObjectResources(ContextClosedEvent event) {
        GemFireMockObjectsSupport.destroy();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.releaseMockObjectResources(event);
    }
}

