/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock.config;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.PoolFactory;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.lang.Nullable;

public class GemFireMockObjectsBeanPostProcessor
implements BeanPostProcessor {
    private static final boolean DEFAULT_USE_SINGLETON_CACHE = false;
    private static final String GEMFIRE_PROPERTIES_BEAN_NAME = "gemfireProperties";
    private volatile boolean useSingletonCache;
    private final AtomicReference<Properties> gemfireProperties = new AtomicReference<Properties>(new Properties());

    public static GemFireMockObjectsBeanPostProcessor newInstance() {
        return GemFireMockObjectsBeanPostProcessor.newInstance(false);
    }

    public static GemFireMockObjectsBeanPostProcessor newInstance(boolean useSingletonCache) {
        GemFireMockObjectsBeanPostProcessor beanPostProcessor = new GemFireMockObjectsBeanPostProcessor();
        beanPostProcessor.useSingletonCache = useSingletonCache;
        return beanPostProcessor;
    }

    @Nullable
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.isGemFireProperties(bean, beanName) ? this.set((Properties)bean) : (bean instanceof CacheFactoryBean ? this.spyOnCacheFactoryBean((CacheFactoryBean)bean, this.useSingletonCache) : (bean instanceof PoolFactoryBean ? this.mockThePoolFactoryBean((PoolFactoryBean)bean) : bean));
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof GemFireCache) {
            GemFireCache gemfireCache = (GemFireCache)bean;
            Mockito.when((Object)gemfireCache.getDistributedSystem().getProperties()).thenReturn((Object)this.gemfireProperties.get());
        }
        return bean;
    }

    private boolean isGemFireProperties(Object bean, String beanName) {
        return bean instanceof Properties && GEMFIRE_PROPERTIES_BEAN_NAME.equals(beanName);
    }

    private Object set(Properties gemfireProperties) {
        this.gemfireProperties.set(gemfireProperties);
        return gemfireProperties;
    }

    private Object spyOnCacheFactoryBean(CacheFactoryBean bean, boolean useSingletonCache) {
        return bean instanceof ClientCacheFactoryBean ? SpyingClientCacheFactoryInitializer.spyOn((ClientCacheFactoryBean)bean, useSingletonCache) : SpyingCacheFactoryInitializer.spyOn(bean, useSingletonCache);
    }

    private Object mockThePoolFactoryBean(PoolFactoryBean bean) {
        return MockingPoolFactoryInitializer.mock(bean);
    }

    protected static class MockingPoolFactoryInitializer
    implements PoolFactoryBean.PoolFactoryInitializer {
        protected MockingPoolFactoryInitializer() {
        }

        protected static PoolFactoryBean mock(PoolFactoryBean poolFactoryBean) {
            poolFactoryBean.setPoolFactoryInitializer((PoolFactoryBean.PoolFactoryInitializer)new MockingPoolFactoryInitializer());
            return poolFactoryBean;
        }

        public PoolFactory initialize(PoolFactory poolFactory) {
            return GemFireMockObjectsSupport.mockPoolFactory();
        }
    }

    protected static class SpyingClientCacheFactoryInitializer
    implements CacheFactoryBean.CacheFactoryInitializer<ClientCacheFactory> {
        private final boolean useSingletonCache;

        protected static ClientCacheFactoryBean spyOn(ClientCacheFactoryBean clientCacheFactoryBean, boolean useSingletonCache) {
            clientCacheFactoryBean.setCacheFactoryInitializer((CacheFactoryBean.CacheFactoryInitializer)new SpyingClientCacheFactoryInitializer(useSingletonCache));
            return clientCacheFactoryBean;
        }

        protected SpyingClientCacheFactoryInitializer(boolean useSingletonCache) {
            this.useSingletonCache = useSingletonCache;
        }

        protected boolean isUsingSingletonCache() {
            return this.useSingletonCache;
        }

        public ClientCacheFactory initialize(ClientCacheFactory clientCacheFactory) {
            return GemFireMockObjectsSupport.spyOn(clientCacheFactory, this.isUsingSingletonCache());
        }
    }

    protected static class SpyingCacheFactoryInitializer
    implements CacheFactoryBean.CacheFactoryInitializer<CacheFactory> {
        private final boolean useSingletonCache;

        protected static CacheFactoryBean spyOn(CacheFactoryBean cacheFactoryBean, boolean useSingletonCache) {
            cacheFactoryBean.setCacheFactoryInitializer((CacheFactoryBean.CacheFactoryInitializer)new SpyingCacheFactoryInitializer(useSingletonCache));
            return cacheFactoryBean;
        }

        protected SpyingCacheFactoryInitializer(boolean useSingletonCache) {
            this.useSingletonCache = useSingletonCache;
        }

        protected boolean isUsingSingletonCache() {
            return this.useSingletonCache;
        }

        public CacheFactory initialize(CacheFactory cacheFactory) {
            return GemFireMockObjectsSupport.spyOn(cacheFactory, this.isUsingSingletonCache());
        }
    }
}

