/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.util.Comparator;
import org.springframework.util.Assert;

public class ByteArrayComparator
implements Comparator<byte[]> {
    public static final ByteArrayComparator INSTANCE = new ByteArrayComparator();

    @Override
    public int compare(byte[] bytesOne, byte[] bytesTwo) {
        int bytesOneLength = bytesOne.length;
        int bytesTwoLength = bytesTwo.length;
        return bytesOneLength < bytesTwoLength ? -1 : (bytesOneLength > bytesTwoLength ? 1 : this.compareByteByByte(bytesOne, bytesTwo));
    }

    private int compareByteByByte(byte[] bytesOne, byte[] bytesTwo) {
        String errorMessage = "The length of the byte arrays do no match; byte array 1 is [%d] and byte array 2 is [%d]";
        Assert.isTrue((bytesOne.length == bytesTwo.length ? 1 : 0) != 0, (String)String.format(errorMessage, bytesOne.length, bytesTwo.length));
        for (int index = 0; index < bytesOne.length; ++index) {
            int diff = bytesOne[index] - bytesTwo[index];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

