/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.springframework.data.gemfire.tests.util.IOUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class FileUtils
extends IOUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isDirectory(File path) {
        return path != null && path.isDirectory();
    }

    public static boolean isFile(File path) {
        return path != null && path.isFile();
    }

    public static File newFile(String pathname) {
        return new File(pathname);
    }

    public static File newFile(File parent, String pathname) {
        return new File(parent, pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        Assert.isTrue((boolean)FileUtils.isFile(file), (String)String.format("The File [%s] to read the contents from is not a valid file", file));
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        try {
            StringBuilder buffer = new StringBuilder();
            String line = fileReader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(LINE_SEPARATOR);
                line = fileReader.readLine();
            }
            String string = buffer.toString().trim();
            return string;
        }
        finally {
            FileUtils.close(fileReader);
        }
    }

    public static void write(File file, String contents) throws IOException {
        Assert.notNull((Object)file, (String)"File is required");
        Assert.isTrue((boolean)StringUtils.hasText((String)contents), (String)String.format("The contents for File [%1$s] cannot be null or empty", file));
        BufferedWriter fileWriter = null;
        try {
            fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(contents);
            fileWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(fileWriter);
            throw throwable;
        }
        IOUtils.close(fileWriter);
    }
}

