/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.junit.Test;
import org.springframework.data.gemfire.tests.util.ThreadUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class StackTraceUtils
extends ThreadUtils {
    private static final AtomicBoolean tracingEnabled = new AtomicBoolean(false);

    @NonNull
    public static String getUniversalTraceIdentifier() {
        String id = UUID.randomUUID().toString();
        String[] idElements = id.split("-");
        return String.format("%s%s%s", idElements[0].substring(0, 3), idElements[3], idElements[idElements.length - 1].substring(idElements[idElements.length - 1].length() - 3));
    }

    @NonNull
    public static StackTraceElement getCaller() {
        return StackTraceUtils.getCaller(Thread.currentThread());
    }

    @NonNull
    public static StackTraceElement getCaller(@NonNull Thread thread) {
        return thread.getStackTrace()[2];
    }

    @NonNull
    public static String getCallerName(@NonNull StackTraceElement element) {
        return String.format("%1$%s.%2$s", element.getClassName(), element.getMethodName());
    }

    @NonNull
    public static String getCallerSimpleName(@NonNull StackTraceElement element) {
        String resolvedClassName = StackTraceUtils.safeResolveClass(element).map(Class::getSimpleName).orElseGet(() -> {
            String className = element.getClassName();
            int index = element.getClassName().lastIndexOf(".");
            return index > -1 ? className.substring(index) : className;
        });
        return String.format("%1$%s.%2$s", resolvedClassName, element.getMethodName());
    }

    @Nullable
    public static StackTraceElement getTestCaller() {
        return StackTraceUtils.getTestCaller(Thread.currentThread());
    }

    @Nullable
    public static StackTraceElement getTestCaller(@NonNull Thread thread) {
        return Arrays.stream(thread.getStackTrace()).filter(StackTraceUtils::isTestSuiteClass).filter(StackTraceUtils::isTestCaseMethod).findFirst().orElse(null);
    }

    private static boolean isTestCaseMethod(StackTraceElement element) {
        boolean result = element.getMethodName().toLowerCase().startsWith("test");
        try {
            result |= StackTraceUtils.resolveMethod(element).isAnnotationPresent(Test.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    private static boolean isTestSuiteClass(StackTraceElement element) {
        boolean result = element.getClassName().toLowerCase().endsWith("test");
        try {
            result |= StackTraceUtils.resolveClass(element).isAssignableFrom(TestCase.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @NonNull
    public static String getStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> resolvedStackTrace = Arrays.stream(stackTrace).filter(StackTraceUtils.stackTraceElementFilter()).collect(Collectors.toList());
        StringWriter writer = new StringWriter();
        Throwable throwable = new Throwable("STACK TRACE DUMP");
        throwable.setStackTrace(resolvedStackTrace.toArray(new StackTraceElement[resolvedStackTrace.size()]));
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static Predicate<StackTraceElement> stackTraceElementFilter() {
        return element -> !StackTraceUtils.class.getName().equals(element.getClassName());
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled.get();
    }

    public static Class<?> resolveClass(StackTraceElement element) throws ClassNotFoundException {
        return Class.forName(element.getClassName());
    }

    public static Optional<Class<?>> safeResolveClass(StackTraceElement element) {
        try {
            return Optional.of(StackTraceUtils.resolveClass(element));
        }
        catch (ClassNotFoundException ignore) {
            return Optional.empty();
        }
    }

    public static Method resolveMethod(StackTraceElement element) throws ClassNotFoundException, NoSuchMethodException {
        return StackTraceUtils.resolveClass(element).getMethod(element.getMethodName(), new Class[0]);
    }

    public static Optional<Method> safeResolveMethod(StackTraceElement element) {
        try {
            return Optional.of(StackTraceUtils.resolveMethod(element));
        }
        catch (ClassNotFoundException | NoSuchMethodException ignore) {
            return Optional.empty();
        }
    }

    public static void whenTracingEnabled(@NonNull Consumer<String> stackTraceConsumer) {
        if (StackTraceUtils.isTracingEnabled()) {
            stackTraceConsumer.accept(StackTraceUtils.getStackTrace());
        }
    }

    public void withTracing() {
        tracingEnabled.set(true);
    }

    public void withoutTracing() {
        tracingEnabled.set(false);
    }
}

