/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public abstract class SpringUtils {
    public static boolean isMatchingBean(BeanFactory beanFactory, String beanName, Class<?> beanType) {
        return beanFactory.containsBean(beanName) && beanFactory.isTypeMatch(beanName, beanType);
    }

    public static BeanDefinition addDependsOn(BeanDefinition beanDefinition, String ... beanNames) {
        ArrayList<String> dependsOnList = new ArrayList<String>();
        Collections.addAll(dependsOnList, ArrayUtils.nullSafeArray(beanDefinition.getDependsOn(), String.class));
        dependsOnList.addAll(Arrays.asList(ArrayUtils.nullSafeArray(beanNames, String.class)));
        beanDefinition.setDependsOn(dependsOnList.toArray(new String[0]));
        return beanDefinition;
    }

    public static Optional<Object> getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        return Optional.ofNullable(beanDefinition).map(BeanDefinition::getPropertyValues).map(propertyValues -> propertyValues.getPropertyValue(propertyName)).map(PropertyValue::getValue);
    }

    public static BeanDefinition setPropertyReference(BeanDefinition beanDefinition, String propertyName, String beanName) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(beanName));
        return beanDefinition;
    }

    public static BeanDefinition setPropertyValue(BeanDefinition beanDefinition, String propertyName, Object propertyValue) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, propertyValue);
        return beanDefinition;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return SpringUtils.defaultIfEmpty(value, () -> defaultValue);
    }

    public static String defaultIfEmpty(String value, Supplier<String> supplier) {
        return StringUtils.hasText((String)value) ? value : supplier.get();
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return (T)SpringUtils.defaultIfNull(value, () -> defaultValue);
    }

    public static <T> T defaultIfNull(T value, Supplier<T> supplier) {
        return value != null ? value : supplier.get();
    }

    public static String dereferenceBean(String beanName) {
        return String.format("%1$s%2$s", "&", beanName);
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean nullOrEquals(Object obj1, Object obj2) {
        return obj1 == null || obj1.equals(obj2);
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    public static String nullSafeName(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String nullSafeSimpleName(Class<?> type) {
        return type != null ? type.getSimpleName() : null;
    }

    public static boolean safeDoOperation(VoidReturningThrowableOperation operation) {
        try {
            operation.run();
            return true;
        }
        catch (Throwable cause) {
            return false;
        }
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier) {
        return SpringUtils.safeGetValue(valueSupplier, null);
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, T defaultValue) {
        return (T)SpringUtils.safeGetValue(valueSupplier, () -> defaultValue);
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, Supplier<T> defaultValueSupplier) {
        return (T)SpringUtils.safeGetValue(valueSupplier, (Throwable exception) -> defaultValueSupplier.get());
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, Function<Throwable, T> exceptionHandler) {
        try {
            return valueSupplier.get();
        }
        catch (Throwable cause) {
            return exceptionHandler.apply(cause);
        }
    }

    public static void safeRunOperation(VoidReturningThrowableOperation operation) {
        SpringUtils.safeRunOperation(operation, cause -> new InvalidDataAccessApiUsageException("Failed to run operation", cause));
    }

    public static void safeRunOperation(VoidReturningThrowableOperation operation, Function<Throwable, RuntimeException> exceptionConverter) {
        try {
            operation.run();
        }
        catch (Throwable cause) {
            throw exceptionConverter.apply(cause);
        }
    }

    @FunctionalInterface
    public static interface VoidReturningThrowableOperation {
        public void run() throws Throwable;
    }

    @Deprecated
    public static interface VoidReturningExceptionThrowingOperation
    extends VoidReturningThrowableOperation {
    }
}

