/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;

public class CreateRegionFunction {
    public static final String CREATE_REGION_FUNCTION_ID = "CreateRegionFunction";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GemfireFunction(id="CreateRegionFunction")
    public boolean createRegion(RegionDefinition regionDefinition) {
        Cache gemfireCache = this.resolveCache();
        if (this.isNonExistingRegion(gemfireCache, regionDefinition)) {
            RegionFactory regionFactory = gemfireCache.createRegionFactory(regionDefinition.getRegionShortcut());
            Region region = regionFactory.create(regionDefinition.getName());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Created Region [{}] of type [{}]", (Object)region.getName(), (Object)region.getAttributes().getDataPolicy());
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Region with name [{}] already exists", (Object)regionDefinition.getName());
        }
        return false;
    }

    protected Cache resolveCache() {
        return CacheFactory.getAnyInstance();
    }

    private boolean isNonExistingRegion(Cache gemfireCache, RegionDefinition regionDefinition) {
        return gemfireCache.getRegion(regionDefinition.getName()) == null;
    }
}

