/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.data.DatasetRepository;
import org.kitesdk.data.filesystem.FileSystemDatasetRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DatasetRepositoryFactory
implements InitializingBean {
    private Configuration conf;
    private DatasetRepository repo;
    private String basePath = "/";

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.conf, (String)"The configuration property is required");
        this.repo = new FileSystemDatasetRepository.Builder().rootDirectory(new URI(this.basePath)).configuration(this.conf).build();
    }

    public DatasetRepository getDatasetRepository() {
        return this.repo;
    }
}

