/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionKey;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.dataset.AbstractDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.AvroPojoDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetOperations;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryCallback;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetUtils;
import org.springframework.data.hadoop.store.dataset.ParquetDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.RecordCallback;
import org.springframework.util.Assert;

public class DatasetTemplate
implements InitializingBean,
DatasetOperations {
    private DatasetRepositoryFactory dsFactory;
    private DatasetDefinition defaultDatasetDefinition;
    private HashMap<String, DatasetDefinition> datasetDefinitions = new HashMap();

    public DatasetTemplate() {
    }

    public DatasetTemplate(DatasetRepositoryFactory dsFactory) {
        this.dsFactory = dsFactory;
    }

    public DatasetTemplate(DatasetRepositoryFactory dsFactory, DatasetDefinition defaultDatasetDefinition) {
        this.dsFactory = dsFactory;
        this.defaultDatasetDefinition = defaultDatasetDefinition;
    }

    public void setDatasetRepositoryFactory(DatasetRepositoryFactory datasetRepositoryFactory) {
        this.dsFactory = datasetRepositoryFactory;
    }

    public DatasetDefinition getDefaultDatasetDefinition() {
        return this.defaultDatasetDefinition;
    }

    public void setDefaultDatasetDefinition(DatasetDefinition defaultDatasetDefinition) {
        this.defaultDatasetDefinition = defaultDatasetDefinition;
        if (defaultDatasetDefinition.getTargetClass() != null) {
            this.datasetDefinitions.put(this.getDatasetName(defaultDatasetDefinition.getTargetClass()), defaultDatasetDefinition);
        }
    }

    public Collection<DatasetDefinition> getDatasetDefinitions() {
        return this.datasetDefinitions.values();
    }

    public void setDatasetDefinitions(Collection<DatasetDefinition> datasetDefinitions) {
        for (DatasetDefinition def : datasetDefinitions) {
            if (def.getTargetClass() != null) {
                this.datasetDefinitions.put(this.getDatasetName(def.getTargetClass()), def);
                continue;
            }
            throw new StoreException("Target class is required for dataset definitions, invalid definition: " + def);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dsFactory, (String)"The datasetRepositoryFactory property is required");
        if (this.defaultDatasetDefinition == null) {
            this.defaultDatasetDefinition = new DatasetDefinition();
        }
    }

    @Override
    public <T> void read(Class<T> targetClass, RecordCallback<T> callback) {
        this.readWithCallback(targetClass, callback, null);
    }

    @Override
    public <T> Collection<T> read(Class<T> targetClass) {
        DatasetDescriptor descriptor = this.getDatasetDescriptor(targetClass);
        if (descriptor == null) {
            throw new StoreException("Unable to locate dataset for target class " + targetClass.getName());
        }
        if (Formats.PARQUET.equals((Object)descriptor.getFormat())) {
            return this.readGenericRecords(targetClass, null);
        }
        return this.readPojo(targetClass, null);
    }

    @Override
    public <T> void read(Class<T> targetClass, RecordCallback<T> callback, PartitionKey partitionKey) {
        this.readWithCallback(targetClass, callback, partitionKey);
    }

    @Override
    public <T> Collection<T> read(Class<T> targetClass, PartitionKey partitionKey) {
        DatasetDescriptor descriptor = this.getDatasetDescriptor(targetClass);
        if (descriptor == null) {
            throw new StoreException("Unable to locate dataset for target class " + targetClass.getName());
        }
        if (Formats.PARQUET.equals((Object)descriptor.getFormat())) {
            return this.readGenericRecords(targetClass, partitionKey);
        }
        return this.readPojo(targetClass, partitionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void readWithCallback(Class<T> targetClass, RecordCallback<T> callback, PartitionKey partitionKey) {
        Dataset<T> dataset = DatasetUtils.getDataset(this.dsFactory, targetClass);
        if (dataset == null) {
            throw new StoreException("Unable to locate dataset for target class " + targetClass.getName());
        }
        DatasetReader reader = null;
        if (partitionKey == null) {
            reader = dataset.newReader();
        } else {
            Dataset partition = dataset.getPartition(partitionKey, false);
            if (partition != null) {
                reader = partition.newReader();
            }
        }
        if (reader != null) {
            try {
                reader.open();
                for (Object t : reader) {
                    callback.doInRecord(t);
                }
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Collection<T> readPojo(Class<T> targetClass, PartitionKey partitionKey) {
        Dataset<T> dataset = DatasetUtils.getDataset(this.dsFactory, targetClass);
        if (dataset == null) {
            throw new StoreException("Unable to locate dataset for target class " + targetClass.getName());
        }
        DatasetReader reader = null;
        if (partitionKey == null) {
            reader = dataset.newReader();
        } else {
            Dataset partition = dataset.getPartition(partitionKey, false);
            if (partition != null) {
                reader = partition.newReader();
            }
        }
        ArrayList results = new ArrayList();
        if (reader != null) {
            try {
                reader.open();
                for (Object r : reader) {
                    results.add(r);
                }
            }
            finally {
                reader.close();
            }
        }
        return results;
    }

    private <T> Collection<T> readGenericRecords(Class<T> targetClass, PartitionKey partitionKey) {
        Dataset<GenericRecord> dataset = DatasetUtils.getOrCreateDataset(this.dsFactory, this.getDatasetDefinitionToUseFor(targetClass), targetClass, GenericRecord.class);
        DatasetReader reader = null;
        if (partitionKey == null) {
            reader = dataset.newReader();
        } else {
            Dataset partition = dataset.getPartition(partitionKey, false);
            if (partition != null) {
                reader = partition.newReader();
            }
        }
        ArrayList<T> results = new ArrayList<T>();
        if (reader != null) {
            try {
                reader.open();
                for (GenericRecord r : reader) {
                    T data = targetClass.newInstance();
                    BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(data);
                    for (Schema.Field f : r.getSchema().getFields()) {
                        if (!beanWrapper.isWritableProperty(f.name())) continue;
                        beanWrapper.setPropertyValue(f.name(), r.get(f.name()));
                    }
                    results.add(data);
                }
            }
            catch (InstantiationException e) {
                throw new StoreException("Unable to read records for class: " + targetClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new StoreException("Unable to read records for class: " + targetClass.getName(), e);
            }
            finally {
                reader.close();
            }
        }
        return results;
    }

    @Override
    public <T> void write(Collection<T> records) {
        if (records == null || records.size() < 1) {
            return;
        }
        Class<?> pojoClass = records.iterator().next().getClass();
        DatasetDefinition datasetDefinition = this.getDatasetDefinitionToUseFor(pojoClass);
        AbstractDatasetStoreWriter writer = Formats.PARQUET.getName().equals(datasetDefinition.getFormat().getName()) ? new ParquetDatasetStoreWriter(pojoClass, this.dsFactory, datasetDefinition) : new AvroPojoDatasetStoreWriter(pojoClass, this.dsFactory, datasetDefinition);
        try {
            for (T rec : records) {
                writer.write(rec);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new StoreException("Error writing " + pojoClass.getName(), e);
        }
    }

    @Override
    public void execute(DatasetRepositoryCallback callback) {
        callback.doInRepository(this.dsFactory.getDatasetRepository());
    }

    @Override
    public <T> DatasetDescriptor getDatasetDescriptor(Class<T> targetClass) {
        try {
            return DatasetUtils.getDataset(this.dsFactory, targetClass).getDescriptor();
        }
        catch (DatasetNotFoundException e) {
            return null;
        }
    }

    @Override
    public <T> String getDatasetName(Class<T> clazz) {
        return DatasetUtils.getDatasetName(clazz);
    }

    private DatasetDefinition getDatasetDefinitionToUseFor(Class<?> targetClass) {
        String datasetName = this.getDatasetName(targetClass);
        if (this.datasetDefinitions.containsKey(datasetName)) {
            return this.datasetDefinitions.get(datasetName);
        }
        return this.defaultDatasetDefinition;
    }
}

