/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Formats;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.dataset.AbstractDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.AvroPojoDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetUtils;
import org.springframework.util.Assert;

public class ParquetDatasetStoreWriter<T>
extends AbstractDatasetStoreWriter<T> {
    private static final Log log = LogFactory.getLog(AvroPojoDatasetStoreWriter.class);
    protected volatile DatasetWriter<GenericRecord> writer;
    protected volatile Schema schema;
    private final Object monitor = new Object();

    public ParquetDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory) {
        this(entityClass, datasetRepositoryFactory, new DatasetDefinition(entityClass, false, Formats.PARQUET.getName()));
    }

    public ParquetDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        super(entityClass, datasetRepositoryFactory, datasetDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T entity) throws IOException {
        Assert.notNull(entity, (String)"Entity to be written can't be 'null'.");
        if (!entity.getClass().equals(this.entityClass)) {
            throw new IllegalArgumentException("Entity to write is of class " + entity.getClass().getName() + ". Expected " + this.entityClass.getName());
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.writer == null) {
                if (Formats.PARQUET.getName().equals(this.datasetDefinition.getFormat().getName())) {
                    Dataset<GenericRecord> dataset = DatasetUtils.getOrCreateDataset(this.datasetRepositoryFactory, this.datasetDefinition, this.entityClass, GenericRecord.class);
                    this.writer = dataset.newWriter();
                    this.schema = dataset.getDescriptor().getSchema();
                } else {
                    throw new StoreException("Invalid format " + this.datasetDefinition.getFormat() + " specified, you must use 'parquet' with " + this.getClass().getSimpleName() + ".");
                }
            }
            if (!this.writer.isOpen()) {
                this.writer.open();
            }
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(this.schema);
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(entity);
        for (Schema.Field f : this.schema.getFields()) {
            if (!beanWrapper.isReadableProperty(f.name())) continue;
            Schema fieldSchema = f.schema();
            if (f.schema().getType().equals((Object)Schema.Type.UNION)) {
                for (Schema s : f.schema().getTypes()) {
                    if (s.getName().equals("null")) continue;
                    fieldSchema = s;
                }
            }
            if (fieldSchema.getType().equals((Object)Schema.Type.RECORD)) {
                throw new StoreException("Nested record currently not supported for field: " + f.name() + " of type: " + beanWrapper.getPropertyDescriptor(f.name()).getPropertyType().getName());
            }
            if (fieldSchema.getType().equals((Object)Schema.Type.BYTES)) {
                ByteBuffer buffer = null;
                Object value = beanWrapper.getPropertyValue(f.name());
                if (value == null || value instanceof byte[]) {
                    if (value != null) {
                        byte[] bytes = (byte[])value;
                        buffer = ByteBuffer.wrap(bytes);
                    }
                    builder.set(f.name(), buffer);
                    continue;
                }
                throw new StoreException("Don't know how to handle " + value.getClass() + " for " + fieldSchema);
            }
            builder.set(f.name(), beanWrapper.getPropertyValue(f.name()));
        }
        try {
            this.writer.write((Object)builder.build());
        }
        catch (ClassCastException cce) {
            throw new StoreException("Failed to write record with schema: " + this.schema, cce);
        }
    }

    @Override
    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushing writer " + this.writer));
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing writer " + this.writer));
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

