/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.hadoop.store.event.AbstractStoreEvent;
import org.springframework.util.StringUtils;

public class LoggingListener
implements ApplicationListener<AbstractStoreEvent> {
    private static final Log log = LogFactory.getLog(LoggingListener.class);
    private final Level level;

    public LoggingListener() {
        this.level = Level.DEBUG;
    }

    public LoggingListener(String level) {
        try {
            this.level = Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid log level '" + level + "'. The (case-insensitive) supported values are: " + StringUtils.arrayToCommaDelimitedString((Object[])Level.values()));
        }
    }

    public void onApplicationEvent(AbstractStoreEvent event) {
        switch (this.level) {
            case FATAL: {
                if (!log.isFatalEnabled()) break;
                log.fatal((Object)event);
                break;
            }
            case ERROR: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)event);
                break;
            }
            case WARN: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)event);
                break;
            }
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)event);
                break;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)event);
                break;
            }
            case TRACE: {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)event);
            }
        }
    }

    private static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

