/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.hadoop.store.expression.DateFormatMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashListMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashRangeMethodExecutor;
import org.springframework.data.hadoop.store.expression.PathCombiningMethodExecutor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;

public class PartitionKeyMethodResolver
implements MethodResolver {
    public static final String METHOD_DATEFORMAT = "dateformat";
    public static final String METHOD_PATH = "path";
    public static final String METHOD_HASH = "hash";
    public static final String METHOD_HASHLIST = "list";
    public static final String METHOD_HASHRANGE = "range";

    public final MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        return this.dispatch(context, targetObject, name, argumentTypes);
    }

    protected MethodExecutor dispatch(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        String methodName;
        String string = methodName = name != null ? name.toLowerCase() : null;
        if (METHOD_DATEFORMAT.equals(methodName)) {
            return this.doDateFormat(context, targetObject, methodName, argumentTypes);
        }
        if (METHOD_PATH.equals(methodName)) {
            return this.doPath(context, targetObject, methodName, argumentTypes);
        }
        if (METHOD_HASH.equals(methodName)) {
            return this.doHash(context, targetObject, methodName, argumentTypes);
        }
        if (METHOD_HASHLIST.equals(methodName)) {
            return this.doHashList(context, targetObject, methodName, argumentTypes);
        }
        if (METHOD_HASHRANGE.equals(methodName)) {
            return this.doHashRange(context, targetObject, methodName, argumentTypes);
        }
        return null;
    }

    protected MethodExecutor doDateFormat(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        if (argumentTypes.size() == 1) {
            return new DateFormatMethodExecutor("timestamp");
        }
        if (argumentTypes.size() == 2 || argumentTypes.size() == 3) {
            return new DateFormatMethodExecutor(null);
        }
        throw new AccessException("Too many or missing arguments");
    }

    protected MethodExecutor doHash(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        return new HashMethodExecutor();
    }

    protected MethodExecutor doPath(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        return new PathCombiningMethodExecutor();
    }

    protected MethodExecutor doHashList(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        return new HashListMethodExecutor();
    }

    protected MethodExecutor doHashRange(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        return new HashRangeMethodExecutor();
    }
}

