/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;

public class PathCombiningMethodExecutor
implements MethodExecutor {
    private static final String DEFAULT_PATH_DELIMITER = "/";
    private final String delimiter;

    public PathCombiningMethodExecutor() {
        this(DEFAULT_PATH_DELIMITER);
    }

    public PathCombiningMethodExecutor(String delimiter) {
        this.delimiter = delimiter;
    }

    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            buf.append(arguments[i]);
            if (i + 1 >= arguments.length) continue;
            buf.append(this.delimiter);
        }
        return new TypedValue((Object)buf.toString());
    }
}

