/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.naming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.strategy.naming.AbstractFileNamingStrategy;
import org.springframework.util.StringUtils;

public class StaticFileNamingStrategy
extends AbstractFileNamingStrategy {
    private static final Log log = LogFactory.getLog(StaticFileNamingStrategy.class);
    private static final String DEFAULT_NAME = "data";
    private String name;
    private String prefix;

    public StaticFileNamingStrategy() {
        this(DEFAULT_NAME);
    }

    public StaticFileNamingStrategy(String name) {
        this.name = name;
    }

    public StaticFileNamingStrategy(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    @Override
    public Path resolve(Path path) {
        String part = this.getNamingPart();
        if (!this.isEnabled() || !StringUtils.hasText((String)part)) {
            return path;
        }
        if (path != null) {
            return new Path(path.getParent(), path.getName() + part);
        }
        return new Path(part);
    }

    @Override
    public void next() {
    }

    @Override
    public Path init(Path path) {
        path = super.init(path);
        log.debug((Object)("Init using path=[" + path + "]"));
        if (path != null) {
            String part = this.getNamingPart();
            if (path.getName().startsWith(part)) {
                String name = path.getName().substring(part.length());
                if (StringUtils.hasText((String)name)) {
                    path = new Path(path.getParent(), name);
                    log.debug((Object)("Removed handled prefix, path is now " + path));
                } else {
                    path = null;
                    log.debug((Object)"Removed last handled name part, returning null");
                }
            }
        }
        return path;
    }

    @Override
    public StaticFileNamingStrategy createInstance() {
        StaticFileNamingStrategy instance = new StaticFileNamingStrategy();
        instance.setCodecInfo(this.getCodecInfo());
        instance.setOrder(this.getOrder());
        instance.setName(this.name);
        instance.setPrefix(this.prefix);
        instance.setEnabled(this.isEnabled());
        return instance;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String getNamingPart() {
        return (StringUtils.hasText((String)this.prefix) ? this.prefix : "") + (StringUtils.hasText((String)this.name) ? this.name : "");
    }
}

