/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;

public class OutputContext {
    private static final Log log = LogFactory.getLog(OutputContext.class);
    private FileNamingStrategy fileNamingStrategy;
    private RolloverStrategy rolloverStrategy;

    public void setWritePosition(long position) {
        if (this.rolloverStrategy != null) {
            this.rolloverStrategy.setWritePosition(position);
        }
    }

    public boolean getRolloverState() {
        if (this.rolloverStrategy != null) {
            return this.rolloverStrategy.hasRolled();
        }
        return false;
    }

    public void rollStrategies() {
        if (this.rolloverStrategy != null) {
            this.rolloverStrategy.reset();
        }
        if (this.fileNamingStrategy != null) {
            this.fileNamingStrategy.next();
        }
    }

    public Path resolvePath(Path path) {
        Path p = this.fileNamingStrategy != null ? this.fileNamingStrategy.resolve(null) : null;
        return p != null ? new Path(path, p) : path;
    }

    public Path init(Path path) {
        log.info((Object)("Init from path=" + path));
        if (this.fileNamingStrategy != null) {
            Path p = this.fileNamingStrategy.init(path);
            if (p != null) {
                this.fileNamingStrategy.reset();
            }
            return p;
        }
        return null;
    }

    public void setCodecInfo(CodecInfo codecInfo) {
        log.info((Object)("Setting codecInfo=" + codecInfo));
        if (this.fileNamingStrategy != null) {
            this.fileNamingStrategy.setCodecInfo(codecInfo);
        }
    }

    public void setFileNamingStrategy(FileNamingStrategy fileNamingStrategy) {
        log.info((Object)("Setting fileNamingStrategy=" + fileNamingStrategy));
        this.fileNamingStrategy = fileNamingStrategy;
    }

    public void setRolloverStrategy(RolloverStrategy rolloverStrategy) {
        log.info((Object)("Setting rolloverStrategy=" + rolloverStrategy));
        this.rolloverStrategy = rolloverStrategy;
    }
}

