/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.hadoop.store.event.StoreEventPublisher;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class StoreContextUtils {
    public static final String TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    public static final String TASK_EXECUTOR_BEAN_NAME = "taskExecutor";

    public static TaskScheduler getTaskScheduler(BeanFactory beanFactory) {
        return StoreContextUtils.getBeanOfType(beanFactory, TASK_SCHEDULER_BEAN_NAME, TaskScheduler.class);
    }

    public static TaskExecutor getTaskExecutor(BeanFactory beanFactory) {
        return StoreContextUtils.getBeanOfType(beanFactory, TASK_EXECUTOR_BEAN_NAME, TaskExecutor.class);
    }

    public static StoreEventPublisher getEventPublisher(BeanFactory beanFactory) {
        return StoreContextUtils.getBeanOfType(beanFactory, "storeEventPublisher", StoreEventPublisher.class);
    }

    private static <T> T getBeanOfType(BeanFactory beanFactory, String beanName, Class<T> type) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            return null;
        }
        return (T)beanFactory.getBean(beanName, type);
    }
}

