/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.support.IdleTimeoutTrigger;
import org.springframework.data.hadoop.store.support.LifecycleObjectSupport;
import org.springframework.data.hadoop.store.support.PollingTaskSupport;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public abstract class StoreObjectSupport
extends LifecycleObjectSupport {
    private static final Log log = LogFactory.getLog(StoreObjectSupport.class);
    private final Configuration configuration;
    private final CodecInfo codecInfo;
    private final Path basePath;
    private IdleTimeoutPoller idlePoller;
    private volatile IdleTimeoutTrigger idleTrigger;
    private volatile long lastIdle = Long.MIN_VALUE;
    private volatile long idleTimeout;

    public StoreObjectSupport(Configuration configuration, Path basePath, CodecInfo codec) {
        this.configuration = configuration;
        this.basePath = basePath;
        this.codecInfo = codec;
    }

    @Override
    protected void onInit() throws Exception {
        if (this.idleTimeout > 0L) {
            this.idleTrigger = new IdleTimeoutTrigger(this.idleTimeout);
            this.idlePoller = new IdleTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.idleTrigger);
            this.idlePoller.init();
        }
    }

    @Override
    protected void doStart() {
        if (this.idlePoller != null) {
            this.idlePoller.start();
        }
    }

    @Override
    protected void doStop() {
        if (this.idlePoller != null) {
            this.idlePoller.stop();
        }
        this.idlePoller = null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Path getPath() {
        return this.basePath;
    }

    public CodecInfo getCodec() {
        return this.codecInfo;
    }

    public boolean isCompressed() {
        return this.codecInfo != null;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void resetIdleTimeout() {
        this.lastIdle = System.currentTimeMillis();
    }

    protected void handleIdleTimeout() {
    }

    private class IdleTimeoutPoller
    extends PollingTaskSupport<Boolean> {
        public IdleTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Boolean doPoll() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Polling idle timeout with idleTimeout=" + StoreObjectSupport.this.idleTimeout + " lastIdle=" + StoreObjectSupport.this.lastIdle));
            }
            return StoreObjectSupport.this.idleTimeout > 0L && StoreObjectSupport.this.lastIdle > 0L && StoreObjectSupport.this.lastIdle + StoreObjectSupport.this.idleTimeout < System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onPollResult(Boolean result) {
            if (result.booleanValue()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Idle timeout detected, calling handleIdleTimeout()");
                    }
                    StoreObjectSupport.this.handleIdleTimeout();
                }
                catch (Exception e) {
                    log.error((Object)"error closing", (Throwable)e);
                }
                finally {
                    StoreObjectSupport.this.lastIdle = Long.MIN_VALUE;
                }
            }
        }
    }
}

