/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.context;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.hadoop.test.context.MiniHadoopCluster;
import org.springframework.data.hadoop.test.support.ConfigurationDelegatingFactoryBean;
import org.springframework.data.hadoop.test.support.HadoopClusterDelegatingFactoryBean;
import org.springframework.test.context.MergedContextConfiguration;

abstract class HadoopClusterInjectUtils {
    HadoopClusterInjectUtils() {
    }

    public static void handleClusterInject(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        Class<MiniHadoopCluster> annotationType = MiniHadoopCluster.class;
        Class testClass = mergedConfig.getTestClass();
        boolean hasMiniHadoopCluster = testClass.isAnnotationPresent(annotationType);
        MiniHadoopCluster annotation = testClass.getAnnotation(annotationType);
        if (hasMiniHadoopCluster) {
            String clusterName = annotation.clusterName();
            String configName = annotation.configName();
            String id = annotation.id();
            int nodeCount = annotation.nodes();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HadoopClusterDelegatingFactoryBean.class);
            builder.addPropertyValue("id", (Object)id);
            builder.addPropertyValue("nodes", (Object)nodeCount);
            context.registerBeanDefinition(clusterName, (BeanDefinition)builder.getBeanDefinition());
            builder = BeanDefinitionBuilder.genericBeanDefinition(ConfigurationDelegatingFactoryBean.class);
            builder.addPropertyReference("cluster", clusterName);
            context.registerBeanDefinition(configName, (BeanDefinition)builder.getBeanDefinition());
        }
    }
}

