/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.support;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.test.context.HadoopCluster;
import org.springframework.data.hadoop.test.support.ClusterInfo;
import org.springframework.data.hadoop.test.support.HadoopClusterManager;

public class HadoopClusterDelegatingFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<HadoopCluster> {
    private HadoopCluster cluster;
    private String id = "default";
    private int nodes = 1;

    public HadoopCluster getObject() throws Exception {
        return this.cluster;
    }

    public Class<HadoopCluster> getObjectType() {
        return HadoopCluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.cluster = HadoopClusterManager.getInstance(true).getCluster(new ClusterInfo(this.id, this.nodes));
    }

    public void destroy() throws Exception {
        if (this.cluster != null) {
            HadoopClusterManager.getInstance().closeCluster(this.cluster);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }
}

