/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.support;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.test.context.HadoopCluster;
import org.springframework.data.hadoop.test.support.StandaloneHadoopCluster;
import org.springframework.util.Assert;

public class HadoopClusterFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<HadoopCluster> {
    private StandaloneHadoopCluster cluster;
    private String clusterId;
    private boolean autoStart;
    private int nodes = 1;

    public StandaloneHadoopCluster getObject() throws Exception {
        return this.cluster;
    }

    public Class<HadoopCluster> getObjectType() {
        return HadoopCluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clusterId, (String)"Cluster id must be set");
        this.cluster = new StandaloneHadoopCluster(this.clusterId, this.nodes);
        if (this.autoStart) {
            this.cluster.start();
        }
    }

    public void destroy() throws Exception {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }
}

