/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.support;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.hadoop.test.context.HadoopCluster;
import org.springframework.data.hadoop.test.support.ClusterInfo;
import org.springframework.data.hadoop.test.support.HadoopClusterFactoryBean;

public class HadoopClusterManager {
    private static final Log log = LogFactory.getLog(HadoopClusterManager.class);
    private static volatile HadoopClusterManager instance = null;
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private Hashtable<ClusterInfo, HadoopCluster> clusters = new Hashtable();

    private HadoopClusterManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopClusterManager getInstance() {
        if (instance != null) return instance;
        Class<HadoopClusterManager> clazz = HadoopClusterManager.class;
        synchronized (HadoopClusterManager.class) {
            if (instance != null) return instance;
            instance = new HadoopClusterManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static HadoopClusterManager getInstance(boolean registerShutdownHook) {
        HadoopClusterManager instance2 = HadoopClusterManager.getInstance();
        if (registerShutdownHook) {
            instance2.registerShutdownHook();
        }
        return instance2;
    }

    public HadoopCluster getCluster(ClusterInfo clusterInfo) {
        HadoopCluster cluster = this.clusters.get(clusterInfo);
        if (cluster == null) {
            log.info((Object)("Building new cluster for ClusterInfo=" + clusterInfo));
            try {
                HadoopClusterFactoryBean fb = new HadoopClusterFactoryBean();
                fb.setClusterId("hadoop-" + clusterInfo.hashCode());
                fb.setAutoStart(true);
                fb.afterPropertiesSet();
                cluster = fb.getObject();
                this.clusters.put(clusterInfo, cluster);
            }
            catch (Exception exception) {}
        } else {
            log.info((Object)("Found cached cluster for ClusterInfo=" + clusterInfo));
        }
        return cluster;
    }

    public boolean closeCluster(HadoopCluster cluster) {
        for (Map.Entry<ClusterInfo, HadoopCluster> entry : this.clusters.entrySet()) {
            if (!entry.getValue().equals(cluster)) continue;
            entry.getValue().stop();
            this.clusters.remove(entry.getKey());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    log.info((Object)"Received shutdown hook, about to call doClose()");
                    HadoopClusterManager.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void doClose() {
        log.info((Object)"Closing all clusters handled by this manager");
        for (Map.Entry<ClusterInfo, HadoopCluster> entry : this.clusters.entrySet()) {
            entry.getValue().stop();
        }
        this.clusters.clear();
    }
}

