/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.support.compat;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class MiniMRClusterCompat {
    private static final Log log = LogFactory.getLog(MiniMRClusterCompat.class);
    private static final String CLASS_FACTORY = "org.apache.hadoop.mapred.MiniMRClientClusterFactory";
    private static final String CLASS_LEGACY = "org.apache.hadoop.mapred.MiniMRCluster";

    public static Object instantiateCluster(Class<?> caller, int nodes, Configuration configuration, FileSystem fileSystem, ClassLoader classLoader) {
        log.info((Object)"Starting minirmcluster via compat");
        Assert.notNull(caller, (String)"Caller class must be set");
        Assert.notNull((Object)fileSystem, (String)"FileSystem must not be null");
        Object cluster = null;
        Class<?> factoryClass = MiniMRClusterCompat.resolveClass(CLASS_FACTORY, classLoader);
        Class<?> legacyClass = MiniMRClusterCompat.resolveClass(CLASS_LEGACY, classLoader);
        log.info((Object)("Cluster classes resolved, factory=" + factoryClass + " legacy=" + legacyClass));
        if (factoryClass != null) {
            Method method = ReflectionUtils.findMethod(factoryClass, (String)"create", (Class[])new Class[]{Class.class, Integer.TYPE, Configuration.class});
            cluster = ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{caller, nodes, configuration});
        } else if (legacyClass != null) {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(legacyClass, (Class[])new Class[]{Integer.TYPE, String.class, Integer.TYPE});
            cluster = BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{nodes, fileSystem.getUri().toString(), 1});
        } else {
            log.error((Object)"Failed to find or instantiate cluster class");
        }
        if (cluster != null) {
            log.info((Object)("Cluster instantiated: " + cluster));
        }
        return cluster;
    }

    public static void stopCluster(Object mrClusterObject) {
        Assert.notNull((Object)mrClusterObject, (String)"mrClusterObject must not be null");
        log.info((Object)("Stopping cluster=" + mrClusterObject));
        Method method = ReflectionUtils.findMethod(mrClusterObject.getClass(), (String)"stop");
        if (method == null) {
            method = ReflectionUtils.findMethod(mrClusterObject.getClass(), (String)"shutdown");
        }
        if (method != null) {
            ReflectionUtils.invokeMethod((Method)method, (Object)mrClusterObject);
        } else {
            log.warn((Object)("Can't find stop/shutdown method for cluster=" + mrClusterObject));
        }
    }

    public static Configuration getConfiguration(Object mrClusterObject) {
        Assert.notNull((Object)mrClusterObject, (String)"mrClusterObject must not be null");
        log.info((Object)("Getting configuration for cluster=" + mrClusterObject));
        Method method = ReflectionUtils.findMethod(mrClusterObject.getClass(), (String)"getConfig");
        if (method == null) {
            method = ReflectionUtils.findMethod(mrClusterObject.getClass(), (String)"createJobConf");
        }
        if (method != null) {
            return (Configuration)ReflectionUtils.invokeMethod((Method)method, (Object)mrClusterObject);
        }
        log.warn((Object)("Can't find configuration for cluster=" + mrClusterObject));
        return null;
    }

    private static Class<?> resolveClass(String clazzName, ClassLoader classLoader) {
        Class clazz = null;
        try {
            clazz = ClassUtils.resolveClassName((String)clazzName, (ClassLoader)classLoader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return clazz;
    }
}

