/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.springframework.data.hadoop.test.context.HadoopCluster;
import org.springframework.data.hadoop.test.support.compat.MiniMRClusterCompat;

public class StandaloneHadoopCluster
implements HadoopCluster {
    private static final Log log = LogFactory.getLog(StandaloneHadoopCluster.class);
    private Object mrClusterObject;
    private MiniDFSCluster dfsCluster = null;
    private final String clusterName;
    private Configuration configuration;
    private final Object startupShutdownMonitor = new Object();
    private boolean started;
    private int nodes = 1;

    public StandaloneHadoopCluster(String clusterName) {
        this.clusterName = clusterName;
    }

    public StandaloneHadoopCluster(String clusterName, int nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        log.info((Object)("Checking if cluster=" + this.clusterName + " needs to be started"));
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            String tmpDir = StandaloneHadoopCluster.getTmpDir();
            System.setProperty("hadoop.log.dir", tmpDir);
            System.setProperty("test.build.data", "build/test/data/" + this.clusterName);
            log.info((Object)("Starting cluster=" + this.clusterName));
            JobConf config = new JobConf();
            String umask = this.getCurrentUmask(tmpDir, (Configuration)config);
            if (umask != null) {
                log.info((Object)("Setting expected umask to " + umask));
                config.set("dfs.datanode.data.dir.perm", umask);
            }
            this.dfsCluster = new MiniDFSCluster((Configuration)config, this.nodes, true, null);
            DistributedFileSystem fs = this.dfsCluster.getFileSystem();
            log.info((Object)("Dfs cluster uri= " + fs.getUri()));
            this.mrClusterObject = MiniMRClusterCompat.instantiateCluster(this.getClass(), this.nodes, (Configuration)config, (FileSystem)fs, this.getClass().getClassLoader());
            this.configuration = MiniMRClusterCompat.getConfiguration(this.mrClusterObject);
            FileSystem.setDefaultUri((Configuration)this.configuration, (URI)fs.getUri());
            log.info((Object)("Started cluster=" + this.clusterName));
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        log.info((Object)("Checking if cluster=" + this.clusterName + " needs to be stopped"));
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            if (this.mrClusterObject != null) {
                MiniMRClusterCompat.stopCluster(this.mrClusterObject);
                this.mrClusterObject = null;
            }
            if (this.dfsCluster != null) {
                this.dfsCluster.shutdown();
                this.dfsCluster = null;
            }
            log.info((Object)("Stopped cluster=" + this.clusterName));
            this.started = false;
        }
    }

    @Override
    public FileSystem getFileSystem() throws IOException {
        return this.dfsCluster != null ? this.dfsCluster.getFileSystem() : null;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }

    private static String getTmpDir() {
        String propTmpPath = System.getProperty("java.io.tmpdir");
        Random random = new Random();
        int rand = 1 + random.nextInt();
        File tmpDir = new File(propTmpPath + File.separator + "hadoopTmpDir" + rand);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        tmpDir.deleteOnExit();
        return tmpDir.getAbsolutePath();
    }

    private String getCurrentUmask(String tmpDir, Configuration config) throws IOException {
        try {
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)config);
            return Integer.toOctalString(localFS.getFileStatus(new Path(StandaloneHadoopCluster.getTmpDir())).getPermission().toShort());
        }
        catch (Exception e) {
            return null;
        }
    }
}

