/*
 * Copyright 2018-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.ldap.core.mapping;

import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

/**
 * Mapping context for {@link LdapPersistentEntity LDAP-specific entities}.
 *
 * @author Mark Paluch
 * @since 2.0.4
 */
public class LdapMappingContext extends AbstractMappingContext<BasicLdapPersistentEntity<?>, LdapPersistentProperty> {

	/**
	 * Creates a new {@link LdapMappingContext}.
	 */
	public LdapMappingContext() {
		setSimpleTypeHolder(LdapSimpleTypes.HOLDER);
	}

	/* (non-Javadoc)
	 * @see org.springframework.data.mapping.context.AbstractMappingContext#createPersistentEntity(org.springframework.data.util.TypeInformation)
	 */
	@Override
	protected <T> BasicLdapPersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
		return new BasicLdapPersistentEntity<>(typeInformation);
	}

	/* (non-Javadoc)
	 * @see org.springframework.data.mapping.context.AbstractMappingContext#createPersistentProperty(org.springframework.data.mapping.model.Property, org.springframework.data.mapping.model.MutablePersistentEntity, org.springframework.data.mapping.model.SimpleTypeHolder)
	 */
	@Override
	protected LdapPersistentProperty createPersistentProperty(Property property, BasicLdapPersistentEntity<?> owner,
			SimpleTypeHolder simpleTypeHolder) {
		return new LdapPersistentProperty(property, owner, simpleTypeHolder);
	}
}
