/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class AbstractAggregationExpression
implements AggregationExpression {
    private final Object value;

    protected AbstractAggregationExpression(Object value) {
        this.value = value;
    }

    @Override
    public DBObject toDbObject(AggregationOperationContext context) {
        return this.toDbObject(this.value, context);
    }

    public DBObject toDbObject(Object value, AggregationOperationContext context) {
        return new BasicDBObject(this.getMongoMethod(), this.unpack(value, context));
    }

    protected static List<Field> asFields(String ... fieldRefs) {
        if (ObjectUtils.isEmpty((Object[])fieldRefs)) {
            return Collections.emptyList();
        }
        return Fields.fields(fieldRefs).asList();
    }

    private Object unpack(Object value, AggregationOperationContext context) {
        if (value instanceof AggregationExpression) {
            return ((AggregationExpression)value).toDbObject(context);
        }
        if (value instanceof Field) {
            return context.getReference((Field)value).toString();
        }
        if (value instanceof List) {
            List sourceList = (List)value;
            ArrayList<Object> mappedList = new ArrayList<Object>(sourceList.size());
            for (Object item : sourceList) {
                mappedList.add(this.unpack(item, context));
            }
            return mappedList;
        }
        if (value instanceof Map) {
            BasicDBObject targetDbo = new BasicDBObject();
            for (Map.Entry item : ((Map)value).entrySet()) {
                targetDbo.put((String)item.getKey(), this.unpack(item.getValue(), context));
            }
            return targetDbo;
        }
        return value;
    }

    protected List<Object> append(Object value) {
        if (this.value instanceof List) {
            ArrayList<Object> clone = new ArrayList<Object>((List)this.value);
            if (value instanceof List) {
                clone.addAll((List)value);
            } else {
                clone.add(value);
            }
            return clone;
        }
        return Arrays.asList(this.value, value);
    }

    protected Map<String, Object> append(String key, Object value) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        LinkedHashMap<String, Object> clone = new LinkedHashMap<String, Object>((Map)this.value);
        clone.put(key, value);
        return clone;
    }

    protected List<Object> values() {
        if (this.value instanceof List) {
            return new ArrayList<Object>((List)this.value);
        }
        if (this.value instanceof Map) {
            return new ArrayList<Object>(((Map)this.value).values());
        }
        return new ArrayList<Object>(Collections.singletonList(this.value));
    }

    protected <T> T get(int index) {
        return (T)this.values().get(index);
    }

    protected <T> T get(Object key) {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        return (T)((Map)this.value).get(key);
    }

    protected Map<String, Object> argumentMap() {
        Assert.isInstanceOf(Map.class, (Object)this.value, (String)"Value must be a type of Map!");
        return Collections.unmodifiableMap((Map)this.value);
    }

    protected boolean contains(Object key) {
        if (!(this.value instanceof Map)) {
            return false;
        }
        return ((Map)this.value).containsKey(key);
    }

    protected abstract String getMongoMethod();
}

