/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.mongodb.AbstractMongodbQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.util.Assert;

public abstract class QuerydslRepositorySupport {
    private final MongoOperations template;
    private final MappingContext<? extends MongoPersistentEntity<?>, ?> context;

    public QuerydslRepositorySupport(MongoOperations operations) {
        Assert.notNull((Object)operations, (String)"MongoOperations must not be null!");
        this.template = operations;
        this.context = operations.getConverter().getMappingContext();
    }

    protected <T> AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> from(EntityPath<T> path) {
        Assert.notNull(path, (String)"EntityPath must not be null!");
        MongoPersistentEntity entity = (MongoPersistentEntity)this.context.getPersistentEntity(path.getType());
        return this.from(path, entity.getCollection());
    }

    protected <T> AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> from(EntityPath<T> path, String collection) {
        Assert.notNull(path, (String)"EntityPath must not be null!");
        Assert.hasText((String)collection, (String)"Collection name must not be null or empty!");
        return new SpringDataMongodbQuery(this.template, path.getType(), collection);
    }
}

