/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIFacade;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.query.RestCypherQueryEngine;
import org.neo4j.rest.graphdb.query.RestGremlinQueryEngine;
import org.neo4j.rest.graphdb.transaction.NullTransaction;
import org.neo4j.rest.graphdb.transaction.NullTransactionManager;
import org.neo4j.rest.graphdb.util.ResultConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.rest.SpringRestCypherQueryEngine;
import org.springframework.data.neo4j.rest.SpringRestGremlinQueryEngine;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class SpringRestGraphDatabase
extends RestGraphDatabase
implements GraphDatabase {
    private ConversionService conversionService;
    private org.springframework.data.neo4j.conversion.ResultConverter resultConverter;

    public SpringRestGraphDatabase(RestAPI api) {
        super(api);
    }

    public SpringRestGraphDatabase(String uri) {
        this((RestAPI)new RestAPIFacade(uri));
    }

    public SpringRestGraphDatabase(String uri, String user, String password) {
        this((RestAPI)new RestAPIFacade(uri, user, password));
    }

    public Node createNode(Map<String, Object> props) {
        return super.getRestAPI().createNode(props);
    }

    public Transaction beginTx() {
        return new NullTransaction();
    }

    public TransactionManager getTxManager() {
        return new NullTransactionManager();
    }

    public Node getOrCreateNode(String indexName, String key, Object value, Map<String, Object> properties) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        RestIndex nodeIndex = this.index().forNodes(indexName);
        return this.getRestAPI().getOrCreateNode(nodeIndex, key, value, properties);
    }

    public Relationship getOrCreateRelationship(String indexName, String key, Object value, Node startNode, Node endNode, String type, Map<String, Object> properties) {
        RestIndex relIndex = (RestIndex)this.index().forRelationships(indexName);
        return this.getRestAPI().getOrCreateRelationship(relIndex, key, value, (RestNode)startNode, (RestNode)endNode, type, properties);
    }

    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> properties) {
        return super.getRestAPI().createRelationship(startNode, endNode, type, properties);
    }

    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        try {
            return super.getRestAPI().getIndex(indexName);
        }
        catch (IllegalArgumentException iea) {
            throw new NoSuchIndexException(indexName);
        }
    }

    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType indexType) {
        return super.getRestAPI().createIndex(type, indexName, indexType.getConfig());
    }

    public TraversalDescription traversalDescription() {
        return super.getRestAPI().createTraversalDescription();
    }

    public <T> QueryEngine<T> queryEngineFor(QueryType type, org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
        switch (type) {
            case Cypher: {
                return new SpringRestCypherQueryEngine(new RestCypherQueryEngine(this.getRestAPI(), (ResultConverter)new SpringResultConverter(resultConverter)));
            }
            case Gremlin: {
                return new SpringRestGremlinQueryEngine(new RestGremlinQueryEngine(this.getRestAPI(), (ResultConverter)new SpringResultConverter(resultConverter)));
            }
        }
        throw new IllegalArgumentException("Unknown Query Engine Type " + type);
    }

    public <T> QueryEngine<T> queryEngineFor(QueryType type) {
        return this.queryEngineFor(type, this.createResultConverter());
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    private org.springframework.data.neo4j.conversion.ResultConverter createResultConverter() {
        if (this.resultConverter != null) {
            return this.resultConverter;
        }
        this.resultConverter = this.conversionService != null ? new ConversionServiceQueryResultConverter(this.conversionService) : new DefaultConverter();
        return this.resultConverter;
    }

    public boolean transactionIsRunning() {
        return true;
    }

    public TransactionManager getTransactionManager() {
        return new NullTransactionManager();
    }

    public void remove(Node node) {
        this.removeFromIndexes(node);
        node.delete();
    }

    public void remove(Relationship relationship) {
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    public void setResultConverter(org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    private void removeFromIndexes(Node node) {
        RestIndexManager indexManager = this.index();
        for (String indexName : indexManager.nodeIndexNames()) {
            indexManager.forNodes(indexName).remove((PropertyContainer)node);
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        RestIndexManager indexManager = this.index();
        for (String indexName : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(indexName).remove((PropertyContainer)relationship);
        }
    }

    static {
        System.setProperty("org.neo4j.rest.batch_transaction", "false");
    }

    private static class SpringResultConverter
    implements ResultConverter {
        private final org.springframework.data.neo4j.conversion.ResultConverter resultConverter;

        public SpringResultConverter(org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
            this.resultConverter = resultConverter;
        }

        public Object convert(Object value, Class target) {
            return this.resultConverter.convert(value, target);
        }
    }
}

