/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Collection;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIFacade;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.transaction.NullTransaction;
import org.neo4j.rest.graphdb.transaction.NullTransactionManager;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.rest.SpringRestCypherQueryEngine;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.schema.SchemaIndexProvider;

public class SpringRestGraphDatabase
extends RestGraphDatabase
implements GraphDatabase {
    private static final String[] NO_LABELS;
    private ConversionService conversionService;
    private ResultConverter resultConverter;
    private SchemaIndexProvider schemaIndexProvider = new SchemaIndexProvider((GraphDatabase)this);

    public SpringRestGraphDatabase(RestAPI api) {
        super(api);
    }

    public SpringRestGraphDatabase(String uri) {
        this((RestAPI)new RestAPIFacade(uri));
    }

    public SpringRestGraphDatabase(String uri, String user, String password) {
        this((RestAPI)new RestAPIFacade(uri, user, password));
    }

    public Node createNode(Map<String, Object> props, Collection<String> labels) {
        RestAPI restAPI = super.getRestAPI();
        RestNode node = restAPI.createNode(props);
        if (labels != null && !labels.isEmpty()) {
            restAPI.addLabels(node, this.toLabels(labels));
        }
        return node;
    }

    private String[] toLabels(Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return NO_LABELS;
        }
        return labels.toArray(new String[labels.size()]);
    }

    public Transaction beginTx() {
        return new NullTransaction();
    }

    public TransactionManager getTxManager() {
        return new NullTransactionManager();
    }

    public Node getOrCreateNode(String indexName, String key, Object value, Map<String, Object> properties, Collection<String> labels) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        RestIndex nodeIndex = this.index().forNodes(indexName);
        RestNode node = this.getRestAPI().getOrCreateNode(nodeIndex, key, value, properties);
        this.getRestAPI().addLabels(node, this.toLabels(labels));
        return node;
    }

    public Node merge(String labelName, String key, Object value, Map<String, Object> nodeProperties, Collection<String> labels) {
        return this.schemaIndexProvider.merge(labelName, key, value, nodeProperties, labels);
    }

    public Relationship getOrCreateRelationship(String indexName, String key, Object value, Node startNode, Node endNode, String type, Map<String, Object> properties) {
        RestIndex relIndex = (RestIndex)this.index().forRelationships(indexName);
        return this.getRestAPI().getOrCreateRelationship(relIndex, key, value, (RestNode)startNode, (RestNode)endNode, type, properties);
    }

    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> properties) {
        return super.getRestAPI().createRelationship(startNode, endNode, type, properties);
    }

    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        try {
            return super.getRestAPI().getIndex(indexName);
        }
        catch (IllegalArgumentException iea) {
            throw new NoSuchIndexException(indexName);
        }
    }

    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType indexType) {
        return super.getRestAPI().createIndex(type, indexName, indexType.getConfig());
    }

    public CypherQueryEngine queryEngine(ResultConverter resultConverter) {
        return new SpringRestCypherQueryEngine(this.getRestAPI(), resultConverter);
    }

    public CypherQueryEngine queryEngine() {
        return this.queryEngine(this.createResultConverter());
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    private ResultConverter createResultConverter() {
        if (this.resultConverter != null) {
            return this.resultConverter;
        }
        this.resultConverter = this.conversionService != null ? new ConversionServiceQueryResultConverter(this.conversionService) : new DefaultConverter();
        return this.resultConverter;
    }

    public boolean transactionIsRunning() {
        return true;
    }

    public TransactionManager getTransactionManager() {
        return new NullTransactionManager();
    }

    public void remove(Node node) {
        this.removeFromIndexes(node);
        node.delete();
    }

    public void remove(Relationship relationship) {
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    public void setResultConverter(ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    private void removeFromIndexes(Node node) {
        RestIndexManager indexManager = this.index();
        for (String indexName : indexManager.nodeIndexNames()) {
            indexManager.forNodes(indexName).remove((PropertyContainer)node);
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        RestIndexManager indexManager = this.index();
        for (String indexName : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(indexName).remove((PropertyContainer)relationship);
        }
    }

    static {
        System.setProperty("org.neo4j.rest.batch_transaction", "false");
        NO_LABELS = new String[0];
    }
}

