/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.relatedto.Experience;
import org.springframework.data.neo4j.annotation.relatedto.Job;

@NodeEntity
public class CareerProfile
extends IdentifiableEntity {
    private String name;
    @RelatedTo(enforceTargetType=true)
    private Set<Experience> experience = new HashSet<Experience>();
    @RelatedTo(type="experience", enforceTargetType=true)
    private Set<Job> jobs = new HashSet<Job>();

    public CareerProfile() {
    }

    public CareerProfile(String name) {
        this.name = name;
    }

    public void addExperience(Experience ... experience) {
        this.experience.addAll(Arrays.asList(experience));
    }

    public void addJobs(Job ... jobs) {
        this.jobs.addAll(Arrays.asList(jobs));
    }

    public Set<Experience> getExperience() {
        return this.experience;
    }

    public Set<Job> getJobs() {
        return this.jobs;
    }
}

