/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.SetHelper;
import org.springframework.data.neo4j.annotation.RelationshipDelegates;
import org.springframework.data.neo4j.annotation.relatedto.Activity;
import org.springframework.data.neo4j.annotation.relatedto.ActivityRepository;
import org.springframework.data.neo4j.annotation.relatedto.Advisor;
import org.springframework.data.neo4j.annotation.relatedto.AdvisorRepository;
import org.springframework.data.neo4j.annotation.relatedto.AnimalRepository;
import org.springframework.data.neo4j.annotation.relatedto.Apple;
import org.springframework.data.neo4j.annotation.relatedto.AppleRepository;
import org.springframework.data.neo4j.annotation.relatedto.AppleStore;
import org.springframework.data.neo4j.annotation.relatedto.AppleStoreRepository;
import org.springframework.data.neo4j.annotation.relatedto.BoardMember;
import org.springframework.data.neo4j.annotation.relatedto.BoardMemberRepository;
import org.springframework.data.neo4j.annotation.relatedto.Book;
import org.springframework.data.neo4j.annotation.relatedto.BookRepository;
import org.springframework.data.neo4j.annotation.relatedto.CareerProfile;
import org.springframework.data.neo4j.annotation.relatedto.CareerProfileRepository;
import org.springframework.data.neo4j.annotation.relatedto.Carnivore;
import org.springframework.data.neo4j.annotation.relatedto.Chairman;
import org.springframework.data.neo4j.annotation.relatedto.ChairmanRepository;
import org.springframework.data.neo4j.annotation.relatedto.CoffeeMachine;
import org.springframework.data.neo4j.annotation.relatedto.CoffeeMachineRepository;
import org.springframework.data.neo4j.annotation.relatedto.Course;
import org.springframework.data.neo4j.annotation.relatedto.CourseRepository;
import org.springframework.data.neo4j.annotation.relatedto.DripBrew;
import org.springframework.data.neo4j.annotation.relatedto.DripBrewRepository;
import org.springframework.data.neo4j.annotation.relatedto.EspressoBasedCoffee;
import org.springframework.data.neo4j.annotation.relatedto.EspressoBasedCoffeeRepository;
import org.springframework.data.neo4j.annotation.relatedto.Experience;
import org.springframework.data.neo4j.annotation.relatedto.ExperienceRepository;
import org.springframework.data.neo4j.annotation.relatedto.Friend;
import org.springframework.data.neo4j.annotation.relatedto.FriendRepository;
import org.springframework.data.neo4j.annotation.relatedto.FruitBowl;
import org.springframework.data.neo4j.annotation.relatedto.FruitBowlRepository;
import org.springframework.data.neo4j.annotation.relatedto.Herbivore;
import org.springframework.data.neo4j.annotation.relatedto.Hero;
import org.springframework.data.neo4j.annotation.relatedto.HeroRepository;
import org.springframework.data.neo4j.annotation.relatedto.Human;
import org.springframework.data.neo4j.annotation.relatedto.HumanRepository;
import org.springframework.data.neo4j.annotation.relatedto.Initiative;
import org.springframework.data.neo4j.annotation.relatedto.InitiativeRepository;
import org.springframework.data.neo4j.annotation.relatedto.Job;
import org.springframework.data.neo4j.annotation.relatedto.JobRepository;
import org.springframework.data.neo4j.annotation.relatedto.MacBook;
import org.springframework.data.neo4j.annotation.relatedto.MacBookRepository;
import org.springframework.data.neo4j.annotation.relatedto.MainHandWeapon;
import org.springframework.data.neo4j.annotation.relatedto.MainHandWeaponRepository;
import org.springframework.data.neo4j.annotation.relatedto.MarvelCharacter;
import org.springframework.data.neo4j.annotation.relatedto.MarvelCharacterRepository;
import org.springframework.data.neo4j.annotation.relatedto.Mondrian;
import org.springframework.data.neo4j.annotation.relatedto.MondrianRepository;
import org.springframework.data.neo4j.annotation.relatedto.OffHandWeapon;
import org.springframework.data.neo4j.annotation.relatedto.OffHandWeaponRepository;
import org.springframework.data.neo4j.annotation.relatedto.Organisation;
import org.springframework.data.neo4j.annotation.relatedto.OrganisationRepository;
import org.springframework.data.neo4j.annotation.relatedto.Rectangle;
import org.springframework.data.neo4j.annotation.relatedto.RectangleRepository;
import org.springframework.data.neo4j.annotation.relatedto.Restaurant;
import org.springframework.data.neo4j.annotation.relatedto.RestaurantRepository;
import org.springframework.data.neo4j.annotation.relatedto.RetinaMacBook;
import org.springframework.data.neo4j.annotation.relatedto.RetinaMacBookRepository;
import org.springframework.data.neo4j.annotation.relatedto.Shop;
import org.springframework.data.neo4j.annotation.relatedto.ShopRepository;
import org.springframework.data.neo4j.annotation.relatedto.ShoppingCenter;
import org.springframework.data.neo4j.annotation.relatedto.ShoppingCenterRepository;
import org.springframework.data.neo4j.annotation.relatedto.Square;
import org.springframework.data.neo4j.annotation.relatedto.SquareRepository;
import org.springframework.data.neo4j.annotation.relatedto.Student;
import org.springframework.data.neo4j.annotation.relatedto.StudentRepository;
import org.springframework.data.neo4j.annotation.relatedto.SuperHuman;
import org.springframework.data.neo4j.annotation.relatedto.SuperHumanRepository;
import org.springframework.data.neo4j.annotation.relatedto.Superhero;
import org.springframework.data.neo4j.annotation.relatedto.SuperheroRepository;
import org.springframework.data.neo4j.annotation.relatedto.Team;
import org.springframework.data.neo4j.annotation.relatedto.TeamRepository;
import org.springframework.data.neo4j.annotation.relatedto.Town;
import org.springframework.data.neo4j.annotation.relatedto.TownRepository;
import org.springframework.data.neo4j.annotation.relatedto.Warchief;
import org.springframework.data.neo4j.annotation.relatedto.WarchiefRepository;
import org.springframework.data.neo4j.annotation.relatedto.WorldOfWarcraftCharacter;
import org.springframework.data.neo4j.annotation.relatedto.WorldOfWarcraftCharacterRepository;
import org.springframework.data.neo4j.annotation.relatedto.Zoo;
import org.springframework.data.neo4j.annotation.relatedto.ZooRepository;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.PersistentEntityConversionException;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@Transactional
public class RelatedToTests {
    @Autowired
    private BookRepository books;
    @Autowired
    private TownRepository towns;
    @Autowired
    private WarchiefRepository warchiefs;
    @Autowired
    private AdvisorRepository advisors;
    @Autowired
    private MarvelCharacterRepository marvelCharacters;
    @Autowired
    private ActivityRepository activities;
    @Autowired
    private AnimalRepository animals;
    @Autowired
    private ZooRepository zsl;
    @Autowired
    private ShopRepository shops;
    @Autowired
    private RestaurantRepository restaurants;
    @Autowired
    private ShoppingCenterRepository shoppingCenters;
    @Autowired
    private MainHandWeaponRepository mainHandWeapons;
    @Autowired
    private OffHandWeaponRepository offHandWeapons;
    @Autowired
    private WorldOfWarcraftCharacterRepository worldOfWarcraftCharacters;
    @Autowired
    private CourseRepository courses;
    @Autowired
    private StudentRepository students;
    @Autowired
    private ExperienceRepository experiences;
    @Autowired
    private JobRepository jobs;
    @Autowired
    private CareerProfileRepository linkedin;
    @Autowired
    private DripBrewRepository dripBrews;
    @Autowired
    private EspressoBasedCoffeeRepository americanos;
    @Autowired
    private CoffeeMachineRepository coffeeMachines;
    @Autowired
    private AppleRepository apples;
    @Autowired
    private FruitBowlRepository fruitbowls;
    @Autowired
    private MacBookRepository macBookRepository;
    @Autowired
    private RetinaMacBookRepository retinaMacBooks;
    @Autowired
    private AppleStoreRepository appleStores;
    @Autowired
    private FriendRepository friends;
    @Autowired
    private ChairmanRepository chairmen;
    @Autowired
    private BoardMemberRepository boardMembers;
    @Autowired
    private OrganisationRepository organisations;
    @Autowired
    private SquareRepository squares;
    @Autowired
    private RectangleRepository rectangles;
    @Autowired
    private MondrianRepository mondrians;
    @Autowired
    private TeamRepository teams;
    @Autowired
    private HumanRepository humans;
    @Autowired
    private SuperHumanRepository superHumans;
    @Autowired
    private SuperheroRepository superheroes;
    @Autowired
    private HeroRepository heroes;
    @Autowired
    private InitiativeRepository initiatives;
    @Autowired
    private Neo4jTemplate template;
    @Autowired
    Neo4jMappingContext context;

    @BeforeTransaction
    public void before() {
        Neo4jHelper.cleanDb(this.template);
    }

    @Test
    public void shouldMapRelationshipEvenWithoutAnnotation() throws Exception {
        Book theHobbit = (Book)this.books.save(new Book("The Hobbit"));
        Book theTwoTowers = (Book)this.books.save(new Book("The Two Towers"));
        Book theReturnOfTheKing = (Book)this.books.save(new Book("The Return of the King"));
        Book theFellowship = new Book("The Fellowship of the Ring");
        theFellowship.follows(theHobbit);
        theFellowship.hasTrilogyPeers(theTwoTowers, theReturnOfTheKing);
        this.books.save(theFellowship);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, theFellowship), (Matcher)Matchers.is(SetHelper.asSet("prequel", "peers")));
        theFellowship = (Book)this.books.findOne(theFellowship.getId());
        Assert.assertThat((Object)theFellowship.getPrequel(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)theHobbit)));
        Assert.assertThat(theFellowship.getTrilogyPeers(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(theTwoTowers, theReturnOfTheKing))));
    }

    @Test
    public void shouldRelateNodesUsingFieldNameAsRelationshipType() throws Exception {
        Town malmo = (Town)this.towns.save(new Town("Malm\u00f6"));
        Town newcastle = new Town("Newcastle");
        newcastle.isTwinnedWith(malmo);
        Town gateshead = (Town)this.towns.save(new Town("Gateshead"));
        Town sunderland = (Town)this.towns.save(new Town("Sunderland"));
        newcastle.hasNeighbours(gateshead, sunderland);
        this.towns.save(newcastle);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, newcastle), (Matcher)Matchers.is(SetHelper.asSet("twin", "neighbours")));
        newcastle = (Town)this.towns.findOne(newcastle.getId());
        Assert.assertThat((Object)newcastle.getTwin(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)malmo)));
        Assert.assertThat(newcastle.getNeighbours(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(gateshead, sunderland))));
    }

    @Test
    public void shouldRelateNodesUsingAnnotationProvidedRelationshipType() throws Exception {
        Warchief orgrim = (Warchief)this.warchiefs.save(new Warchief("Orgrim Doomhammer"));
        Warchief thrall = new Warchief("Thrall, Son of Durotan");
        thrall.succeeds(orgrim);
        Advisor garrosh = (Advisor)this.advisors.save(new Advisor("Garrosh Hellscream"));
        Advisor rehgar = (Advisor)this.advisors.save(new Advisor("Rehgar Earthfury"));
        thrall.hasAdvisors(garrosh, rehgar);
        this.warchiefs.save(thrall);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, thrall), (Matcher)Matchers.is(SetHelper.asSet("succeeds", "is_advised_by")));
        thrall = (Warchief)this.warchiefs.findOne(thrall.getId());
        Assert.assertThat((Object)thrall.getMentor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)orgrim)));
        Assert.assertThat(thrall.getAdvisors(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(garrosh, rehgar))));
    }

    @Test
    public void shouldNotDifferentiateByEndNodeClassWhenTargetTypeNotEnforced() throws Exception {
        Neo4jPersistentEntityImpl entity = (Neo4jPersistentEntityImpl)this.context.getPersistentEntity(CoffeeMachine.class);
        Assert.assertTrue((boolean)((Neo4jPersistentProperty)entity.getPersistentProperty("dripBrew")).isRelationship());
        Assert.assertTrue((boolean)((Neo4jPersistentProperty)entity.getPersistentProperty("espressoBasedCoffee")).isRelationship());
        DripBrew filteredCoffee = (DripBrew)this.dripBrews.save(new DripBrew("Filtered Coffee"));
        EspressoBasedCoffee americano = (EspressoBasedCoffee)this.americanos.save(new EspressoBasedCoffee("Americano"));
        CoffeeMachine coffeeMachine = new CoffeeMachine();
        coffeeMachine.produces(filteredCoffee);
        coffeeMachine.produces(americano);
        try {
            this.coffeeMachines.save(coffeeMachine);
            Assert.fail();
        }
        catch (PersistentEntityConversionException e) {
            Assert.assertThat(SetHelper.asSet(DripBrew.class.getName(), EspressoBasedCoffee.class.getName()), (Matcher)Matchers.hasItem((Object)e.getSourceType().getName()));
            Assert.assertThat(SetHelper.asSet(DripBrew.class.getName(), EspressoBasedCoffee.class.getName()), (Matcher)Matchers.hasItem((Object)e.getTargetType().getName()));
            Assert.assertThat((Object)e.getSourceType().getName(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)e.getTargetType().getName()))));
        }
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedBetweenFields() throws Exception {
        MarvelCharacter betty = (MarvelCharacter)this.marvelCharacters.save(new MarvelCharacter("Betty Ross"));
        Activity smashing = (Activity)this.activities.save(new Activity("smashing"));
        MarvelCharacter hulk = new MarvelCharacter("Hulk");
        hulk.favours(betty);
        hulk.loves(smashing);
        this.marvelCharacters.save(hulk);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, hulk), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("favourite"))));
        hulk = (MarvelCharacter)this.marvelCharacters.findOne(hulk.getId());
        Assert.assertThat((Object)hulk.getFavourite(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)betty)));
        Assert.assertThat((Object)hulk.getFavouriteActivity(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)smashing)));
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedBetweenCollections() throws Exception {
        Shop appleStore = (Shop)this.shops.save(new Shop("Apple Store"));
        Shop hAndM = (Shop)this.shops.save(new Shop("H&M"));
        Restaurant wahaca = (Restaurant)this.restaurants.save(new Restaurant("Wahaca"));
        Restaurant busabaEathai = (Restaurant)this.restaurants.save(new Restaurant("Busaba Eathai"));
        ShoppingCenter westfield = new ShoppingCenter("Westfield - Stratford City");
        westfield.houses(appleStore, hAndM);
        westfield.houses(wahaca, busabaEathai);
        this.shoppingCenters.save(westfield);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, westfield), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("houses"))));
        westfield = (ShoppingCenter)this.shoppingCenters.findOne(westfield.getId());
        Assert.assertThat(westfield.getShops(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(appleStore, hAndM))));
        Assert.assertThat(westfield.getRestaurants(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(wahaca, busabaEathai))));
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedBetweenFieldAndCollection() throws Exception {
        Chairman jacquesRogge = (Chairman)this.chairmen.save(new Chairman("Jacques Rogge"));
        BoardMember boardMember1 = (BoardMember)this.boardMembers.save(new BoardMember("Denis Oswald"));
        BoardMember boardMember2 = (BoardMember)this.boardMembers.save(new BoardMember("Ren\u00e9 Fasel"));
        BoardMember boardMember3 = (BoardMember)this.boardMembers.save(new BoardMember("Frank Fredericks"));
        Organisation ioc = new Organisation("THE INTERNATIONAL OLYMPIC COMMITTEE");
        ioc.setChairman(jacquesRogge);
        ioc.add(boardMember1, boardMember2, boardMember3);
        this.organisations.save(ioc);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, ioc), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("executive"))));
        ioc = (Organisation)this.organisations.findOne(ioc.getId());
        Assert.assertThat((Object)ioc.getChairman(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)jacquesRogge)));
        Assert.assertThat(ioc.getBoardMembers(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(boardMember1, boardMember2, boardMember3))));
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypesIdenticalBetweenFields() throws Exception {
        Friend sam = (Friend)this.friends.save(new Friend("Samwise Gamgee"));
        Friend pippin = (Friend)this.friends.save(new Friend("Peregrin Took"));
        Friend frodo = new Friend("Frodo Baggins");
        frodo.isFriendsWith(pippin);
        frodo.isBestFriendsWith(sam);
        this.friends.save(frodo);
        Assert.assertThat((Object)RelationshipDelegates.getNumberOfRelationships(this.template, frodo), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypesIdenticalBetweenCollections() throws Exception {
        Course probabilityTheory = (Course)this.courses.save(new Course("Probability Theory"));
        Course geometry = (Course)this.courses.save(new Course("Geometry"));
        Course statistics = (Course)this.courses.save(new Course("Statistics"));
        Course calculus = (Course)this.courses.save(new Course("Calculus"));
        Student student = new Student("Ferris Bueller");
        student.likes(probabilityTheory, geometry);
        student.isBoredWith(statistics, calculus);
        this.students.save(student);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, student), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("attends"))));
        student = (Student)this.students.findOne(student.getId());
        Assert.assertThat(student.getFavouriteCourses(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo(SetHelper.asSet(probabilityTheory, geometry))).or(Matchers.equalTo(SetHelper.asSet(statistics, calculus)))));
        Assert.assertThat(student.getDislikedCourses(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo(SetHelper.asSet(probabilityTheory, geometry))).or(Matchers.equalTo(SetHelper.asSet(statistics, calculus)))));
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypesIdenticalBetweenFieldAndCollection() throws Exception {
        Apple redApple1 = (Apple)this.apples.save(new Apple("red"));
        Apple redApple2 = (Apple)this.apples.save(new Apple("red"));
        Apple greenApple = (Apple)this.apples.save(new Apple("green"));
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addRedApples(redApple1, redApple2);
        fruitBowl.setGreenApple(greenApple);
        try {
            this.fruitbowls.save(fruitBowl);
            Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, fruitBowl), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("contains"))));
            fruitBowl = (FruitBowl)this.fruitbowls.findOne(fruitBowl.getId());
            Assert.assertThat(fruitBowl.getRedApples(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(greenApple))));
            Assert.assertThat((Object)fruitBowl.getGreenApple(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)greenApple)));
        }
        catch (InvalidDataAccessApiUsageException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Cannot obtain single field value for field 'greenApple'")));
        }
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedOnFieldsSharingSuperType() throws Exception {
        MainHandWeapon mainHandWeapon = (MainHandWeapon)this.mainHandWeapons.save(new MainHandWeapon("Warglaive of Azzinoth"));
        OffHandWeapon offHandWeapon = (OffHandWeapon)this.offHandWeapons.save(new OffHandWeapon("Warglaive of Azzinoth"));
        WorldOfWarcraftCharacter illidanStormrage = new WorldOfWarcraftCharacter("Illidan Stormrage");
        illidanStormrage.wields(mainHandWeapon);
        illidanStormrage.wields(offHandWeapon);
        this.worldOfWarcraftCharacters.save(illidanStormrage);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, illidanStormrage), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("wields"))));
        illidanStormrage = (WorldOfWarcraftCharacter)this.worldOfWarcraftCharacters.findOne(illidanStormrage.getId());
        Assert.assertThat(illidanStormrage.getWeapons(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(mainHandWeapon, offHandWeapon))));
        Assert.assertThat((Object)illidanStormrage.getMainHandWeapon(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)mainHandWeapon)));
        Assert.assertThat((Object)illidanStormrage.getOffHandWeapon(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)offHandWeapon)));
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedOnCollectionsSharingSuperType() throws Exception {
        Herbivore deer = (Herbivore)this.animals.save(new Herbivore("Deer"));
        Herbivore giraffe = (Herbivore)this.animals.save(new Herbivore("Giraffe"));
        Carnivore lion = (Carnivore)this.animals.save(new Carnivore("Lion"));
        Carnivore tiger = (Carnivore)this.animals.save(new Carnivore("Tiger"));
        Zoo zsl = new Zoo("ZSL London Zoo");
        zsl.exhibits(deer);
        zsl.exhibits(giraffe);
        zsl.exhibits(lion);
        zsl.exhibits(tiger);
        this.zsl.save(zsl);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, zsl), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("exhibit"))));
        zsl = (Zoo)this.zsl.findOne(zsl.getId());
        Assert.assertThat(zsl.getAllAnimals(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(deer, giraffe, lion, tiger))));
        Assert.assertThat(zsl.getHerbivores(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(deer, giraffe))));
        Assert.assertThat(zsl.getCarnivores(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(lion, tiger))));
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedOnFieldAndCollectionSharingSuperType() throws Exception {
        Square redSquare = (Square)this.squares.save(new Square(Mondrian.RED));
        Rectangle yellowRectangle = (Rectangle)this.rectangles.save(new Rectangle(Mondrian.YELLOW));
        Rectangle blueRectangle = (Rectangle)this.rectangles.save(new Rectangle(Mondrian.BLUE));
        Mondrian mondrian = new Mondrian("Composition with Yellow, Blue and Red");
        mondrian.includes(redSquare);
        mondrian.includes(yellowRectangle, blueRectangle);
        this.mondrians.save(mondrian);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, mondrian), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("includes"))));
        mondrian = (Mondrian)this.mondrians.findOne(mondrian.getId());
        Assert.assertThat(mondrian.getQuadrilaterals(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(redSquare, yellowRectangle, blueRectangle))));
        Assert.assertThat((Object)mondrian.getSquare(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)redSquare)));
        Assert.assertThat(mondrian.getRectangles(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(yellowRectangle, blueRectangle))));
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypeSubstitutableBetweenFields() throws Exception {
        MacBook macbook = (MacBook)this.macBookRepository.save(new MacBook());
        RetinaMacBook retinaMacbook = (RetinaMacBook)this.retinaMacBooks.save(new RetinaMacBook());
        AppleStore appleStore = new AppleStore();
        appleStore.suppliesMacBook(macbook);
        appleStore.suppliesRetinaMacBook(retinaMacbook);
        try {
            this.appleStores.save(appleStore);
            Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, appleStore), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("supplies"))));
            appleStore = (AppleStore)this.appleStores.findOne(appleStore.getId());
            Assert.assertThat((Object)IteratorUtil.single(appleStore.getSupplies()), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MacBook.class)));
        }
        catch (InvalidDataAccessApiUsageException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Cannot obtain single field value for field 'macBook'")));
        }
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypeSubstitutableBetweenCollections() {
        Experience college = (Experience)this.experiences.save(new Experience("Reed College (calligraphy mainly)"));
        Experience sabbatical = (Experience)this.experiences.save(new Experience("Neem Karoli ashram, found enlightenment"));
        Job atari = (Job)this.jobs.save(new Job("Technician at Atari"));
        Job apple = (Job)this.jobs.save(new Job("Co-founder, Chairman and CEO, Apple Inc."));
        CareerProfile steveJobs = new CareerProfile("Steven Paul Jobs");
        steveJobs.addExperience(college, sabbatical);
        steveJobs.addJobs(atari, apple);
        this.linkedin.save(steveJobs);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, steveJobs), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("experience"))));
        steveJobs = (CareerProfile)this.linkedin.findOne(steveJobs.getId());
        Assert.assertThat(steveJobs.getExperience(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo(SetHelper.asSet(college, sabbatical))).or(Matchers.equalTo(SetHelper.asSet(college, sabbatical, atari, apple)))));
        Assert.assertThat(steveJobs.getJobs(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.equalTo(Collections.emptySet())).or(Matchers.equalTo(SetHelper.asSet(atari, apple)))));
    }

    @Test
    public void shouldDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedAndEndNodeTypeForFieldInheritsFromEndNodeTypeForCollection() throws Exception {
        Human sam = (Human)this.humans.save(new Human("Samantha Carter"));
        Human daniel = (Human)this.humans.save(new Human("Daniel Jackson"));
        Human tealc = (Human)this.humans.save(new Human("Tealc"));
        SuperHuman jack = (SuperHuman)this.superHumans.save(new SuperHuman("Jack O'Neill"));
        Team sg1 = new Team("SG1");
        sg1.setLeader(jack);
        sg1.add(sam, daniel, tealc);
        this.teams.save(sg1);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, sg1), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("member"))));
        Assert.assertThat((Object)sg1.getLeader(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)jack)));
        Assert.assertThat(sg1.getMembers(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(sam, daniel, tealc))));
    }

    @Test
    public void shouldNotDifferentiateClashingRelationshipTypesWhenTargetTypeEnforcedButEndNodeTypeForCollectionInheritsFromEndNodeTypeForField() throws Exception {
        Superhero thor = (Superhero)this.superheroes.save(new Superhero("Thor"));
        Superhero ironMan = (Superhero)this.superheroes.save(new Superhero("Iron Man"));
        Superhero hulk = (Superhero)this.superheroes.save(new Superhero("Hulk"));
        Hero nickFury = (Hero)this.heroes.save(new Hero("Nick Fury"));
        Initiative avengers = new Initiative("Avengers");
        avengers.setLeader(nickFury);
        avengers.add(thor, ironMan, hulk);
        this.initiatives.save(avengers);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, avengers), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet("hero"))));
        avengers = (Initiative)this.initiatives.findOne(avengers.getId());
        Assert.assertThat((Object)avengers.getLeader(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)nickFury)));
        Assert.assertThat(avengers.getMembers(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(SetHelper.asSet(thor, ironMan, hulk))));
    }
}

