/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedtovia;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.relatedtovia.MetroLine;
import org.springframework.data.neo4j.annotation.relatedtovia.TransportInfrastructure;

@NodeEntity
public class City
extends IdentifiableEntity {
    private String name;
    @RelatedToVia
    private Set<TransportInfrastructure> existingMetroLines = new HashSet<TransportInfrastructure>();
    @RelatedToVia(type="planned")
    private Set<TransportInfrastructure> plannedMetroLines = new HashSet<TransportInfrastructure>();

    public City() {
    }

    public City(String name) {
        this.name = name;
    }

    public void has(MetroLine ... metroLines) {
        this.addTo(metroLines, this.existingMetroLines);
    }

    public void plans(MetroLine ... metroLines) {
        this.addTo(metroLines, this.plannedMetroLines);
    }

    private void addTo(MetroLine[] metroLines, Set<TransportInfrastructure> transportInfrastructures) {
        for (MetroLine metroLine : metroLines) {
            transportInfrastructures.add(new TransportInfrastructure(this, metroLine));
        }
    }

    public Set<MetroLine> getCurrentMetroLines() {
        return this.getMetroLines(this.existingMetroLines);
    }

    public Set<MetroLine> getFutureMetroLines() {
        return this.getMetroLines(this.plannedMetroLines);
    }

    private Set<MetroLine> getMetroLines(Set<TransportInfrastructure> transportInfrastructures) {
        HashSet<MetroLine> metroLines = new HashSet<MetroLine>();
        for (TransportInfrastructure transportInfrastructure : transportInfrastructures) {
            metroLines.add(transportInfrastructure.getMetroLine());
        }
        return metroLines;
    }
}

