/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.support.mapping.DefaultEntityIndexCreator;
import org.springframework.data.neo4j.support.mapping.EntityIndexCreator;
import org.springframework.data.neo4j.support.mapping.NoEntityIndexCreator;

public class CreateIndexConfigTests {
    private AbstractApplicationContext ctx;

    @Test
    public void testEnableIndexWithNoConfig() throws Exception {
        this.ctx = new AnnotationConfigApplicationContext(new Class[]{DefaultTestConfiguration.class});
        EntityIndexCreator entityIndexCreator = (EntityIndexCreator)this.ctx.getBean("entityIndexCreator", EntityIndexCreator.class);
        Assert.assertEquals(DefaultEntityIndexCreator.class, entityIndexCreator.getClass());
    }

    @Test
    public void testDisableIndexWithConstructorParam() throws Exception {
        this.ctx = new AnnotationConfigApplicationContext(new Class[]{NoIndexTestConfiguration.class});
        EntityIndexCreator entityIndexCreator = (EntityIndexCreator)this.ctx.getBean("entityIndexCreator", EntityIndexCreator.class);
        Assert.assertEquals(NoEntityIndexCreator.class, entityIndexCreator.getClass());
    }

    @Test
    public void testDisableIndexWithXmlConfig() throws Exception {
        this.ctx = new ClassPathXmlApplicationContext("CreateIndexConfigTests-NoIndex-context.xml", this.getClass());
        EntityIndexCreator entityIndexCreator = (EntityIndexCreator)this.ctx.getBean("entityIndexCreator", EntityIndexCreator.class);
        Assert.assertEquals(NoEntityIndexCreator.class, entityIndexCreator.getClass());
    }

    @Test
    public void testEnableIndexWithDefaultXmlConfig() throws Exception {
        this.ctx = new ClassPathXmlApplicationContext("CreateIndexConfigTests-DefaultIndex-context.xml", this.getClass());
        EntityIndexCreator entityIndexCreator = (EntityIndexCreator)this.ctx.getBean("entityIndexCreator", EntityIndexCreator.class);
        Assert.assertEquals(DefaultEntityIndexCreator.class, entityIndexCreator.getClass());
    }

    @Test
    public void testEnableIndexWithXmlConfig() throws Exception {
        this.ctx = new ClassPathXmlApplicationContext("CreateIndexConfigTests-Index-context.xml", this.getClass());
        EntityIndexCreator entityIndexCreator = (EntityIndexCreator)this.ctx.getBean("entityIndexCreator", EntityIndexCreator.class);
        Assert.assertEquals(DefaultEntityIndexCreator.class, entityIndexCreator.getClass());
    }

    @After
    public void tearDown() throws Exception {
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    @Configuration
    static class NoIndexTestConfiguration
    extends Neo4jConfiguration {
        NoIndexTestConfiguration() {
            this.setCreateIndex(false);
        }

        @Bean(destroyMethod="shutdown")
        public GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }

    @Configuration
    static class DefaultTestConfiguration
    extends Neo4jConfiguration {
        DefaultTestConfiguration() {
        }

        @Bean(destroyMethod="shutdown")
        public GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

