/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.repositories.ClassWithNestedRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@DirtiesContext
public class NestedNeo4jRepositoriesJavaConfigTests {
    @Autowired
    ClassWithNestedRepository.NestedUserRepository nestedUserRepository;

    @Test
    public void shouldSupportNestedRepositories() {
        Assert.assertThat((Object)this.nestedUserRepository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Configuration
    @EnableNeo4jRepositories(basePackageClasses={PersonRepository.class}, considerNestedRepositories=true)
    static class Config
    extends Neo4jConfiguration {
        Config() throws ClassNotFoundException {
            this.setBasePackage(new String[]{Person.class.getPackage().getName()});
        }

        @Bean
        public GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

