/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.equality;

import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.equality.HashCodeCachingEntity;
import org.springframework.data.neo4j.equality.ImproperEntity;
import org.springframework.data.neo4j.equality.ProperEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class EqualityTests {
    @Autowired
    private Neo4jTemplate template;

    @Test
    public void entitiesThatDoNotImplementEqualsAndHashCodeShouldNotBeConsistentAfterSaving() throws Exception {
        HashSet<ImproperEntity> entities = new HashSet<ImproperEntity>();
        ImproperEntity entity = new ImproperEntity();
        entities.add(entity);
        ImproperEntity savedEntity = (ImproperEntity)this.template.save((Object)entity);
        entities.add(savedEntity);
        ImproperEntity foundEntity = (ImproperEntity)this.template.findOne(entity.id.longValue(), ImproperEntity.class);
        entities.add(foundEntity);
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)savedEntity)));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)foundEntity)));
        Assert.assertThat((Object)savedEntity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)foundEntity)));
        Assert.assertThat((Object)entities.contains(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(savedEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(foundEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(savedEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(foundEntity), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void entitiesThatImplementEqualsAndHashCodeShouldBeConsistentAfterSaving() throws Exception {
        HashSet<ProperEntity> entities = new HashSet<ProperEntity>();
        ProperEntity entity = new ProperEntity();
        entities.add(entity);
        ProperEntity savedEntity = (ProperEntity)this.template.save((Object)entity);
        entities.add(savedEntity);
        ProperEntity foundEntity = (ProperEntity)this.template.findOne(entity.id.longValue(), ProperEntity.class);
        entities.add(foundEntity);
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Object)savedEntity));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Object)foundEntity));
        Assert.assertThat((Object)savedEntity, (Matcher)CoreMatchers.is((Object)foundEntity));
        Assert.assertThat((Object)entities.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)entities.contains(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(savedEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(foundEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(savedEntity), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)entities.remove(foundEntity), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(entities.iterator().next(), (Matcher)CoreMatchers.is((Object)entity));
    }

    @Test
    public void entitiesThatCacheHashCodeShouldBeConsistentAfterSaving() throws Exception {
        HashSet<HashCodeCachingEntity> entities = new HashSet<HashCodeCachingEntity>();
        HashCodeCachingEntity entity = new HashCodeCachingEntity();
        entities.add(entity);
        HashCodeCachingEntity savedEntity = (HashCodeCachingEntity)this.template.save((Object)entity);
        entities.add(savedEntity);
        HashCodeCachingEntity foundEntity = (HashCodeCachingEntity)this.template.findOne(entity.id.longValue(), HashCodeCachingEntity.class);
        entities.add(foundEntity);
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)savedEntity)));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)foundEntity)));
        Assert.assertThat((Object)savedEntity, (Matcher)CoreMatchers.is((Object)foundEntity));
        Assert.assertThat((Object)entities.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)entities.contains(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(savedEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.contains(foundEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(entity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(savedEntity), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entities.remove(foundEntity), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)entities.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{"org.springframework.data.neo4j.equality"});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

