/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.fieldaccess.CustomGenericType;
import org.springframework.data.neo4j.fieldaccess.EntityWithGenericProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class GenericPropertyFieldAccessorTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    @Transactional
    public void testGenericIntProperty() {
        this.assertSaveAndRetrieveValueUsingGenericProperty(123);
    }

    @Test
    @Transactional
    public void testGenericDoubleProperty() {
        this.assertSaveAndRetrieveValueUsingGenericProperty(3.1415);
    }

    @Test
    @Transactional
    public void testGenericBooleanProperty() {
        this.assertSaveAndRetrieveValueUsingGenericProperty(true);
    }

    @Test
    @Transactional
    public void testGenericIntegerProperty() {
        this.assertSaveAndRetrieveValueUsingGenericProperty(3);
    }

    @Test
    @Transactional
    public void testTransientGenericPropertyNotSaved() {
        this.assertSaveAndRetrieveValueUsingTransientGenericProperty(3);
    }

    @Test
    @Transactional
    public void testCustomGenericTypePropertyWithNoExplicitConverterThrowsException() {
        try {
            this.assertSaveAndRetrieveValueUsingGenericProperty(new CustomGenericType("custom-stuff"));
        }
        catch (Exception e) {
            boolean isExpectedSpring3Exception = e instanceof ConverterNotFoundException;
            boolean isExpectedSpring4Exception = e instanceof ConversionFailedException;
            Assert.assertTrue((isExpectedSpring3Exception || isExpectedSpring4Exception ? 1 : 0) != 0);
            return;
        }
        Assert.fail((String)"An exception should have occurred");
    }

    @Ignore(value="Not supported without a custom converter")
    @Test
    @Transactional
    public void neo4jGenericCollectionsPropertyTestThrowsException() {
        try {
            ArrayList<Integer> col = new ArrayList<Integer>();
            col.add(1);
            col.add(5);
            col.add(10);
            this.assertSaveAndRetrieveValueUsingGenericProperty(col);
        }
        catch (Exception e) {
            boolean isExpectedSpring4Exception = e instanceof ConversionFailedException;
            Assert.assertTrue((boolean)isExpectedSpring4Exception);
            return;
        }
        Assert.fail((String)"An exception should have occurred already");
    }

    private <T> void assertSaveAndRetrieveValueUsingGenericProperty(T value) {
        EntityWithGenericProperty entity = new EntityWithGenericProperty();
        entity.setGenericProperty(value);
        this.template.save((Object)entity);
        EntityWithGenericProperty loaded = (EntityWithGenericProperty)this.template.findOne(entity.getId().longValue(), EntityWithGenericProperty.class);
        Assert.assertEquals(value, (Object)loaded.getGenericProperty());
    }

    private <T> void assertSaveAndRetrieveValueUsingTransientGenericProperty(T value) {
        EntityWithGenericProperty entity = new EntityWithGenericProperty();
        entity.setTransientGenericProperty(value);
        this.template.save((Object)entity);
        EntityWithGenericProperty loaded = (EntityWithGenericProperty)this.template.findOne(entity.getId().longValue(), EntityWithGenericProperty.class);
        Assert.assertNull((String)"Value was transient and should not have been saved", (Object)loaded.getTransientGenericProperty());
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{EntityWithGenericProperty.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

