/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.fieldaccess.PrefixedDynamicProperties;

public class PrefixedDynamicPropertyTests {
    private static final String VALUE = "value";
    private static final String VALUE2 = "value2";
    private static final String DEFAULT_VALUE = "default_value";
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    private static final String PREFIX = "foo";
    private static final String PREFIXED_KEY = "foo-key";
    private static final String PREFIXED_KEY2 = "foo-key2";
    PrefixedDynamicProperties props = new PrefixedDynamicProperties("foo");

    private <T> List<T> toList(Iterable<T> it) {
        return (List)IteratorUtil.addToCollection(it, new ArrayList());
    }

    @Test
    public void setProperty() {
        Assert.assertFalse((boolean)this.props.hasProperty(KEY));
        Assert.assertFalse((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
        Assert.assertEquals((Object)this.props.getProperty(KEY, (Object)DEFAULT_VALUE), (Object)DEFAULT_VALUE);
        this.props.setProperty(KEY, (Object)VALUE);
        Assert.assertTrue((boolean)this.props.hasProperty(KEY));
        Assert.assertTrue((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
        Assert.assertEquals((Object)this.props.getProperty(KEY), (Object)VALUE);
        Assert.assertEquals((Object)this.props.getPrefixedProperty(PREFIXED_KEY), (Object)VALUE);
        Assert.assertEquals((Object)this.props.getProperty(KEY, (Object)DEFAULT_VALUE), (Object)VALUE);
        this.props.setProperty(KEY2, (Object)VALUE);
        Assert.assertThat(this.toList(this.props.getPropertyKeys()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{KEY, KEY2}));
        Assert.assertThat(this.toList(this.props.getPrefixedPropertyKeys()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{PREFIXED_KEY, PREFIXED_KEY2}));
        this.props.removeProperty(KEY);
        Assert.assertFalse((boolean)this.props.hasProperty(KEY));
        Assert.assertFalse((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
    }

    @Test
    public void setPropertyIfPrefixed() {
        this.props.setPropertyIfPrefixed(KEY, (Object)VALUE);
        Assert.assertFalse((boolean)this.props.hasProperty(KEY));
        Assert.assertFalse((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
        this.props.setPropertyIfPrefixed(PREFIXED_KEY, (Object)VALUE);
        Assert.assertTrue((boolean)this.props.hasProperty(KEY));
        Assert.assertTrue((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
    }

    @Test
    public void setRawProperty() {
        this.props.setPrefixedProperty(PREFIXED_KEY, (Object)VALUE);
        Assert.assertTrue((boolean)this.props.hasPrefixedProperty(PREFIXED_KEY));
        Assert.assertTrue((boolean)this.props.hasProperty(KEY));
    }

    @Test
    public void asMap() {
        this.props.setProperty(KEY, (Object)VALUE);
        this.props.setProperty(KEY2, (Object)VALUE2);
        Map map = this.props.asMap();
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{KEY, KEY2}));
        ArrayList<String> values = new ArrayList<String>(map.size());
        for (String key : map.keySet()) {
            values.add((String)map.get(key));
        }
        Assert.assertThat(values, (Matcher)CoreMatchers.hasItems((Object[])new String[]{VALUE, VALUE2}));
    }

    @Test
    public void createFrom() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(KEY, VALUE);
        m.put(KEY2, VALUE2);
        DynamicProperties p = this.props.createFrom(m);
        Assert.assertTrue((boolean)p.hasProperty(KEY));
        Assert.assertTrue((boolean)p.hasProperty(KEY2));
    }
}

