/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.fieldaccess.CustomType;
import org.springframework.data.neo4j.fieldaccess.EntityWithCustomTypeProperty;
import org.springframework.data.neo4j.repository.CRUDRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class PropertyTypeConversionTests {
    @Autowired
    Neo4jTemplate template;
    CRUDRepository<EntityWithCustomTypeProperty> fooRepository;

    @Before
    public void before() {
        this.fooRepository = this.template.repositoryFor(EntityWithCustomTypeProperty.class);
    }

    @Test
    public void shouldConvertCustomTypeUsingDefaultPropertyType() throws Exception {
        EntityWithCustomTypeProperty entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.save((Object)new EntityWithCustomTypeProperty(new CustomType("some value"), null, null));
        entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.findOne((Serializable)entityWithCustomTypeProperty.id);
        Assert.assertThat((Object)entityWithCustomTypeProperty.customTypeConvertedToString.value, (Matcher)CoreMatchers.is((Object)"some value encoded using string decoded using string"));
    }

    @Test
    public void shouldConvertCustomTypeUsingParameterisedPropertyType() throws Exception {
        EntityWithCustomTypeProperty entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.save((Object)new EntityWithCustomTypeProperty(null, new CustomType("some value"), null));
        entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.findOne((Serializable)entityWithCustomTypeProperty.id);
        Assert.assertThat((Object)entityWithCustomTypeProperty.customTypeConvertedToByteArray.value, (Matcher)CoreMatchers.is((Object)"some value encoded using byte array decoded using byte array"));
    }

    @Test
    public void shouldNotConvertCustomTypeWhenNoConverterExists() throws Exception {
        EntityWithCustomTypeProperty entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.save((Object)new EntityWithCustomTypeProperty(null, null, new CustomType("some value")));
        entityWithCustomTypeProperty = (EntityWithCustomTypeProperty)this.fooRepository.findOne((Serializable)entityWithCustomTypeProperty.id);
        Assert.assertThat((Object)entityWithCustomTypeProperty.unConvertibleCustomType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{EntityWithCustomTypeProperty.class.getPackage().getName()});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }

        protected ConversionService neo4jConversionService() throws Exception {
            ConverterRegistry converterRegistry = (ConverterRegistry)super.neo4jConversionService();
            converterRegistry.addConverter((Converter)new Converter<CustomType, String>(){

                public String convert(CustomType source) {
                    return source.value + " encoded using string";
                }
            });
            converterRegistry.addConverter((Converter)new Converter<String, CustomType>(){

                public CustomType convert(String source) {
                    return new CustomType(source + " decoded using string");
                }
            });
            converterRegistry.addConverter((Converter)new Converter<CustomType, byte[]>(){

                public byte[] convert(CustomType source) {
                    return (source.value + " encoded using byte array").getBytes();
                }
            });
            converterRegistry.addConverter((Converter)new Converter<byte[], CustomType>(){

                public CustomType convert(byte[] source) {
                    return new CustomType(new String(source) + " decoded using byte array");
                }
            });
            return (ConversionService)converterRegistry;
        }
    }
}

