/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import javax.validation.ValidationException;
import javax.validation.Validator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.FriendshipRepository;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.PersonRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class ValidatingPropertyFieldAccessorListenerFactoryTest {
    @Autowired
    private PersonRepository personRepo;
    @Autowired
    private FriendshipRepository friendshipRepo;

    @Test(expected=ValidationException.class)
    public void testNodePropertyValidation() {
        this.personRepo.save(new Person("Li", 102));
    }

    @Test(expected=ValidationException.class)
    public void testRelationshipPropertyValidation() {
        Person john = (Person)this.personRepo.save(new Person("John", 50));
        Person jack = (Person)this.personRepo.save(new Person("Jack", 45));
        Friendship friendship = john.knows(jack);
        friendship.setYears(100);
        this.friendshipRepo.save(friendship);
    }

    @Configuration
    @EnableNeo4jRepositories(basePackageClasses={PersonRepository.class}, considerNestedRepositories=true)
    static class Config
    extends Neo4jConfiguration {
        Config() throws ClassNotFoundException {
            this.setBasePackage(new String[]{Person.class.getPackage().getName()});
        }

        @Bean
        public GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }

        @Bean
        public Validator validator() {
            return new LocalValidatorFactoryBean();
        }
    }
}

