/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import java.util.Collection;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Polygon;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.annotation.ResultColumn;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.Personality;
import org.springframework.data.neo4j.repositories.PersonRepositoryFriendship;
import org.springframework.data.neo4j.repository.CypherDslRepository;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.MemberData;
import org.springframework.data.neo4j.repository.MemberDataPOJO;
import org.springframework.data.neo4j.repository.NamedIndexRepository;
import org.springframework.data.neo4j.repository.RelationshipOperationsRepository;
import org.springframework.data.neo4j.repository.SpatialRepository;
import org.springframework.data.repository.query.Param;

public interface PersonRepository
extends GraphRepository<Person>,
NamedIndexRepository<Person>,
SpatialRepository<Person>,
PersonRepositoryFriendship,
CypherDslRepository<Person>,
RelationshipOperationsRepository<Person> {
    @Query(value="match (team:g)-[:persons]->(member) where id(team) = {p_team} return member")
    public Iterable<Person> findAllTeamMembers(@Param(value="p_team") Group var1);

    @Query(value="match (team:g)-[:persons]->(member) where id(team) = {p_team} return team.name as name,collect(member) as members")
    public TeamResult findAllTeamMembersAsGroup(@Param(value="p_team") Group var1);

    @Query(value="match (team:g)-[:persons]->(member) where id(team) = {p_team} return member.name,member.age")
    public Iterable<Map<String, Object>> findAllTeamMemberData(@Param(value="p_team") Group var1);

    @Query(value="match team-[:persons]->member<-[:boss]-boss where id(member) = {p_person} return collect(team), boss")
    public Iterable<MemberData> findMemberData(@Param(value="p_person") Person var1);

    @Query(value="match team-[:persons]->member<-[:boss]-boss where id(member) = {p_person} return collect(team), boss, boss.name as someonesName, boss.age as someonesAge ")
    public MemberDataPOJO findMemberDataPojo(@Param(value="p_person") Person var1);

    @Query(value="match team-[:persons]->member<-[:boss]-boss where id(member) = {p_person} return member")
    public Iterable<MemberData> nonWorkingQuery(@Param(value="p_person") Person var1);

    @Query(value="MATCH (team:g {name : {p_team}})-[:persons]->(member) return member order by member.name skip {skip} limit {limit}")
    public Iterable<Person> findSomeTeamMembers(@Param(value="p_team") String var1, @Param(value="skip") Integer var2, @Param(value="limit") Integer var3);

    @Query(value="match (boss)-[:boss]->(person) where id(person) = {p_person} return boss")
    public Person findBoss(@Param(value="p_person") Person var1);

    public Collection<Person> findByWktNearAndName(Circle var1, String var2);

    public Collection<Person> findByWktWithinAndAgeGreaterThan(Circle var1, int var2);

    public Collection<Person> findByWktWithinAndPersonality(Polygon var1, Personality var2);

    public Collection<Person> findByWktWithin(Box var1);

    @Query(value="match (boss)-[:boss]->(person) where id(person) = {p_person}  return boss")
    public Person findBoss(@Param(value="p_person") Long var1);

    @Query(value="match (boss)-[:boss]->(person) where id(boss) = {0} with person, count(*) as cnt order by cnt return person")
    public Page<Person> findSubordinates(Person var1, Pageable var2);

    @Query(value="match (boss)-[:boss]->(person) where id(boss) = {0} with person, count(*) as cnt order by cnt return person", countQuery="start boss=node({0}) match (boss)-[:boss]->(person) with person return count(*)")
    public Page<Person> findSubordinatesWithCount(Person var1, Pageable var2);

    public Group findTeam(@Param(value="p_person") Person var1);

    @Query(value="match (team)-[:persons]->(member) where id(team) = {p_team} return member")
    public Page<Person> findAllTeamMembersPaged(@Param(value="p_team") Group var1, Pageable var2);

    @Query(value="match (team)-[:persons]->(member) where id(team) = {p_team} return member")
    public Slice<Person> findAllTeamMembersSliced(@Param(value="p_team") Group var1, Pageable var2);

    @Query(value="match (team)-[:persons]->(member) where id(team) = {p_team} return member")
    public Iterable<Person> findAllTeamMembersSorted(@Param(value="p_team") Group var1, Sort var2);

    public Long countByName(String var1);

    public Iterable<Person> findByName(@Param(value="name") String var1);

    public Iterable<Person> findByNameAndAgeGreaterThan(@Param(value="name") String var1, @Param(value="someAge") int var2);

    public Iterable<Person> findByNameAndAgeLessThan(String var1, int var2);

    public Iterable<Person> findByPersonality(String var1);

    public Iterable<Person> findByAge(int var1);

    public Iterable<Person> findByAlias(@Param(value="alias") String var1);

    @Query(value="start person=node:`name-index`('name:*') return person.name as name, person order by name asc ")
    public Iterable<NameAndPersonResult> getAllNamesAndPeople();

    public Result<Person> findByHeight(short var1);

    @QueryResult
    public static interface TeamResult {
        public String getName();

        @ResultColumn(value="members")
        public Collection<Person> getMembers();
    }

    @QueryResult
    public static interface NameAndPersonResult {
        @ResultColumn(value="name")
        public String getName();

        @ResultColumn(value="person")
        public Person getPerson();
    }
}

