/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.StartExpression;
import org.neo4j.cypherdsl.grammar.Execute;
import org.neo4j.cypherdsl.querydsl.CypherQueryDSL;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.QPerson;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/repository/GraphRepositoryTests-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
@Transactional
@Ignore
public class CypherDslRepositoryTests {
    @Autowired
    PersonRepository personRepository;
    @Autowired
    Neo4jOperations template;
    private TestTeam team;
    private Map<String, Object> peopleParams;
    private Execute query = CypherQueryDSL.start((StartExpression[])new StartExpression[]{CypherQueryDSL.nodeByParameter((String)"n", (String)"people")}).returns(new Expression[]{CypherQueryDSL.identifier((String)"n")});
    private Execute countQuery = CypherQueryDSL.start((StartExpression[])new StartExpression[]{CypherQueryDSL.nodeByParameter((String)"n", (String)"people")}).returns(new Expression[]{CypherQueryDSL.count()});
    private Execute query2;

    public CypherDslRepositoryTests() {
        this.query2 = CypherQueryDSL.start((StartExpression[])new StartExpression[]{CypherQueryDSL.nodeByparameter((Identifier)CypherQueryDSL.identifier((Path)QPerson.person), (String)"people")}).where(CypherQueryDSL.toBooleanExpression((Predicate)QPerson.person.name.eq((Object)"Michael"))).returns(new Expression[]{CypherQueryDSL.identifier((Path)QPerson.person)});
    }

    @Before
    public void setUp() throws Exception {
        this.team = new TestTeam().createSDGTeam(this.template);
        this.peopleParams = MapUtil.map((Object[])new Object[]{"people", Arrays.asList(this.team.michael.getId(), this.team.david.getId(), this.team.emil.getId())});
    }

    @Test
    public void testQueryPaged() throws Exception {
        Page result = this.personRepository.query(this.query, this.peopleParams, (Pageable)new PageRequest(0, 2));
        Assert.assertThat((Object)result.getContent(), (Matcher)Matchers.hasItems((Object[])new Person[]{this.team.michael, this.team.david}));
    }

    @Test
    public void testQueryPagedWithCount() throws Exception {
        Page result = this.personRepository.query(this.query, this.countQuery, this.peopleParams, (Pageable)new PageRequest(0, 1));
        Assert.assertThat((Object)result.getContent(), (Matcher)Matchers.hasItems((Object[])new Person[]{this.team.michael}));
        Assert.assertThat((Object)result.getTotalElements(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQuery() throws Exception {
        List result = (List)this.personRepository.query(this.query, this.peopleParams).as(List.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.hasItems((Object[])new Person[]{this.team.michael, this.team.david, this.team.emil}));
    }

    @Test
    public void testQueryDSL() throws Exception {
        List michaelOnly = (List)this.personRepository.query(this.query2, this.peopleParams).as(List.class);
        Assert.assertThat((Object)michaelOnly, (Matcher)Matchers.hasItems((Object[])new Person[]{this.team.michael}));
    }
}

