/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.SetHelper;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.CookBook;
import org.springframework.data.neo4j.repository.CookBookRepository;
import org.springframework.data.neo4j.repository.Dish;
import org.springframework.data.neo4j.repository.DishRepository;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.Ingredient;
import org.springframework.data.neo4j.repository.Recipe;
import org.springframework.data.neo4j.repository.RecipeRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class DerivedFinderTests {
    private Dish dish;
    private Transaction transaction;
    @Autowired
    private GraphDatabaseService graphDatabaseService;
    @Autowired
    private Neo4jTemplate template;
    @Autowired
    private RecipeRepository recipeRepository;
    @Autowired
    private DishRepository dishRepository;
    @Autowired
    private CookBookRepository cookBookRepository;
    private Ingredient fish;
    private Ingredient spice;
    private Ingredient oliveOil;
    private Ingredient pear;
    private Ingredient chocolate;
    private CookBook nakedChef;
    private CookBook baking101;
    private Recipe focaccia;
    private Recipe chocolateFudgeCake;
    private Recipe whiteChocolateSquares;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        Neo4jHelper.cleanDb(this.graphDatabaseService, false);
        GraphRepository ingredientRepository = this.template.repositoryFor(Ingredient.class);
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            this.chocolate = (Ingredient)ingredientRepository.save((Object)new Ingredient("chocolate"));
            this.fish = (Ingredient)ingredientRepository.save((Object)new Ingredient("fish"));
            this.spice = (Ingredient)ingredientRepository.save((Object)new Ingredient("spice x"));
            this.oliveOil = (Ingredient)ingredientRepository.save((Object)new Ingredient("olive oil"));
            this.pear = (Ingredient)ingredientRepository.save((Object)new Ingredient("pear"));
            this.nakedChef = (CookBook)this.template.repositoryFor(CookBook.class).save((Object)new CookBook("Naked Chef"));
            this.baking101 = (CookBook)this.template.repositoryFor(CookBook.class).save((Object)new CookBook("baking101"));
            this.recipeRepository.save(new Recipe("Hugh", "Bouillabaisse", this.fish, null, null));
            this.recipeRepository.save(new Recipe("Hugh", "pear frangipane", this.pear, null, this.baking101));
            this.recipeRepository.save(new Recipe("The Colonel", "fried chicken", null, this.spice, null));
            this.recipeRepository.save(new Recipe("Jamie", "pesto", this.oliveOil, null, this.nakedChef));
            this.focaccia = (Recipe)this.recipeRepository.save(new Recipe("Hugh", "focaccia", this.oliveOil, null, this.baking101));
            this.chocolateFudgeCake = (Recipe)this.recipeRepository.save(new Recipe("Nigella", "Chocolate Fudge cake", this.chocolate, null, null));
            this.whiteChocolateSquares = (Recipe)this.recipeRepository.save(new Recipe("Heston", "White Chocolate squares", this.chocolate, null, null));
            this.dish = (Dish)this.dishRepository.save(new Dish(100));
            tx.success();
        }
        tx = this.graphDatabaseService.beginTx();
        try {
            for (Node node : this.graphDatabaseService.getAllNodes()) {
                System.out.println("node = " + node);
            }
            tx.success();
        }
        finally {
            tx.close();
        }
        this.transaction = this.graphDatabaseService.beginTx();
    }

    @After
    public void tearDown() throws Exception {
        if (this.transaction != null) {
            this.transaction.success();
            this.transaction.close();
            this.transaction = null;
        }
    }

    @Test
    public void shouldFindUsingSingleProperty() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByAuthor("Hugh");
        Assert.assertThat(this.getIngredientNames(recipes), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(SetHelper.asSet("fish", "pear", "olive oil"))));
    }

    private Set<String> getIngredientNames(Set<Recipe> recipes) {
        HashSet<String> ingredientNames = new HashSet<String>();
        for (Recipe recipe : recipes) {
            ingredientNames.add(recipe.ingredient.name);
        }
        return ingredientNames;
    }

    @Test
    public void shouldFindUsingMultipleProperties() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByAuthorAndTitle("Hugh", "pear frangipane");
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).ingredient.name, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"pear")));
    }

    @Test
    public void shouldFindUsingEntity() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByIngredient(this.fish);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).author, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Hugh")));
    }

    @Test
    public void shouldFindUsingEntityId() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByIngredientId(this.fish.id);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).author, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Hugh")));
    }

    @Test
    public void shouldFindUsingOwnGraphId() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findById(this.focaccia.id);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).id, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.focaccia.id)));
    }

    @Test
    public void shouldFindUsingMultipleEntities() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByIngredientAndCookBook(this.pear, this.baking101);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).title, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"pear frangipane")));
    }

    @Test
    public void shouldFindByRelationshipPropertyEntities() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findBySecrets(this.spice);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).author, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"The Colonel")));
    }

    @Test
    public void shouldFindUsingEntityWithIncomingRelationship() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findBySecret(this.spice);
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).author, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"The Colonel")));
    }

    @Test
    public void shouldFindUsingEntityAndProperty() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByIngredientAndAuthor(this.oliveOil, "Jamie");
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).author, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Jamie")));
    }

    @Test
    public void shouldCountCorrectlyUsingProperty() throws Exception {
        Long actualCountVal = this.recipeRepository.countByAuthor("Hugh");
        Assert.assertThat((Object)actualCountVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
    }

    @Test
    public void shouldCountCorrectlyUsingEntityAndProperty() throws Exception {
        Long actualCountVal = this.recipeRepository.countByIngredientAndAuthor(this.oliveOil, "Hugh");
        Assert.assertThat((Object)actualCountVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void shouldCountCorrectlyUsingEntity() throws Exception {
        Long actualCountVal = this.recipeRepository.countByIngredient(this.chocolate);
        Assert.assertThat((Object)actualCountVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
    }

    @Test
    public void shouldCountCorrectlyUsingPropertyTraversal() throws Exception {
        Integer actualCountVal = this.recipeRepository.countByCookBookTitle("Naked Chef");
        Assert.assertThat((Object)actualCountVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
    }

    @Test
    public void shouldFindUsingEntityAndPropertyTraversal() throws Exception {
        Set<Recipe> recipes = this.recipeRepository.findByIngredientAndCookBookTitle(this.oliveOil, "Naked Chef");
        for (Node node : this.graphDatabaseService.getAllNodes()) {
            System.out.println("in test = " + node);
        }
        Assert.assertThat((Object)((Recipe)IteratorUtil.single(recipes)).title, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"pesto")));
    }

    @Test
    public void shouldFindUsingIndexedNumericValue() throws Exception {
        Dish foundDish = this.dishRepository.findByNumber(100);
        Assert.assertThat((Object)foundDish.number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dish.number)));
    }

    @Test
    public void shouldFindCorrectlyOrderedUsingMethodSignatureAscending() {
        Iterable<Recipe> recipes = this.recipeRepository.findByIngredientOrderByAuthorAsc(this.chocolate);
        List recs = (List)IteratorUtil.asCollection(recipes);
        Assert.assertThat((Object)recs.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertEquals((Object)"Heston", (Object)((Recipe)recs.get((int)0)).author);
        Assert.assertEquals((Object)"Nigella", (Object)((Recipe)recs.get((int)1)).author);
    }

    @Test
    public void shouldFindCorrectlyOrderedUsingMethodSignatureDescending() {
        Iterable<Recipe> recipes = this.recipeRepository.findByIngredientOrderByAuthorDesc(this.chocolate);
        List recs = (List)IteratorUtil.asCollection(recipes);
        Assert.assertThat((Object)recs.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertEquals((Object)"Nigella", (Object)((Recipe)recs.get((int)0)).author);
        Assert.assertEquals((Object)"Heston", (Object)((Recipe)recs.get((int)1)).author);
    }

    @Test
    public void shouldFindCorrectlyOrderedUsingSortParam() {
        Sort.Order order = new Sort.Order(Sort.Direction.DESC, "author");
        Sort sort = new Sort(new Sort.Order[]{order});
        Iterable<Recipe> recipes = this.recipeRepository.findByIngredient(this.chocolate, sort);
        List recs = (List)IteratorUtil.asCollection(recipes);
        Assert.assertThat((Object)recs.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertEquals((Object)"Nigella", (Object)((Recipe)recs.get((int)0)).author);
        Assert.assertEquals((Object)"Heston", (Object)((Recipe)recs.get((int)1)).author);
    }

    @Test
    public void shouldFindByMultipleRelatedProperties() {
        Set<Recipe> jamieR = this.recipeRepository.findByAuthor("Jamie");
        Assert.assertThat((Object)jamieR.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        CookBook book = this.cookBookRepository.findByTitle("Naked Chef");
        Assert.assertThat((Object)book, (Matcher)CoreMatchers.notNullValue());
        Set<CookBook> books = this.cookBookRepository.findByRecipesAuthor("Jamie");
        Assert.assertThat((Object)books.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)books.iterator().next().title, (Matcher)CoreMatchers.equalTo((Object)"Naked Chef"));
        books = this.cookBookRepository.findByRecipesTitle("pesto");
        Assert.assertThat((Object)books.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)books.iterator().next().title, (Matcher)CoreMatchers.equalTo((Object)"Naked Chef"));
        books = this.cookBookRepository.findByRecipesAuthorAndRecipesTitle("Jamie", "pesto");
        Assert.assertThat((Object)books.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)books.iterator().next().title, (Matcher)CoreMatchers.equalTo((Object)"Naked Chef"));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() throws ClassNotFoundException {
            this.setBasePackage(new String[]{"org.springframework.data.neo4j.repository", "org.springframework.data.neo4j.model"});
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

