/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.neo4j.repository.GeoConverter;

public class GeoConverterTest {
    public static final Point POINT_1 = new Point(1.23, -4.56);
    public static final Point POINT_2 = new Point(-1.23, 4.56);
    public static final Point POINT_3 = new Point(0.0, 2.0);
    public static final Point POINT_4 = new Point(4.0, 0.0);
    public static final Point POINT_5 = new Point(1.23, 4.56);
    public static final Point POINT_6 = new Point(-1.23, -4.56);

    @Test
    public void testToWktCoords() throws Exception {
        Assert.assertEquals((Object)"1.23 -4.56", (Object)GeoConverter.toWktCoords((Point)POINT_1));
    }

    @Test
    public void testToWkt() throws Exception {
        Assert.assertEquals((Object)"POLYGON((1.23 -4.56,-1.23 4.56,0.0 2.0,1.23 -4.56))", (Object)GeoConverter.toWkt((Polygon)new Polygon(POINT_1, POINT_2, POINT_3, new Point[0])));
    }

    @Test
    public void testToWellKnownText() throws Exception {
        Assert.assertEquals((Object)"POLYGON((1.23 -4.56,-1.23 4.56,0.0 2.0,1.23 -4.56))", (Object)GeoConverter.toWellKnownText((Shape)new Polygon(POINT_1, POINT_2, POINT_3, new Point[0])));
        Assert.assertEquals((Object)"POINT(1.23 -4.56)", (Object)GeoConverter.toWellKnownText((Point)POINT_1));
        Assert.assertEquals((Object)"POINT(-1.23 4.56)", (Object)GeoConverter.toWellKnownText((Point)POINT_2));
        Assert.assertEquals((Object)"POINT(0.0 2.0)", (Object)GeoConverter.toWellKnownText((Point)POINT_3));
    }

    @Test
    public void testToPolygon() throws Exception {
        Assert.assertEquals((Object)new Polygon(POINT_1, POINT_6, POINT_2, new Point[]{POINT_5}), (Object)GeoConverter.toPolygon((Box)new Box(POINT_1, POINT_2)));
    }

    @Test
    public void testFromWellKnownText() throws Exception {
        Assert.assertEquals((Object)new Polygon(POINT_1, POINT_2, POINT_3, new Point[0]), (Object)GeoConverter.fromWellKnownText((String)"POLYGON((1.23 -4.56,-1.23 4.56,0.0 2.0,1.23 -4.56))"));
    }

    @Test
    public void testPointFromWellKnownText() throws Exception {
        Assert.assertEquals((Object)POINT_1, (Object)GeoConverter.pointFromWellKnownText((String)"POINT(1.23 -4.56)"));
        Assert.assertEquals((Object)POINT_2, (Object)GeoConverter.pointFromWellKnownText((String)"POINT(-1.23 4.56)"));
        Assert.assertEquals((Object)POINT_3, (Object)GeoConverter.pointFromWellKnownText((String)"POINT(0 2)"));
        Assert.assertEquals((Object)POINT_4, (Object)GeoConverter.pointFromWellKnownText((String)"POINT(4 0)"));
    }
}

