/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.repository.CookBook;
import org.springframework.data.neo4j.repository.Ingredient;

@NodeEntity
class Recipe {
    @GraphId
    Long id;
    String author;
    String title;
    @Fetch
    Ingredient ingredient;
    @RelatedTo(type="HAS_RECIPE", direction=Direction.INCOMING)
    CookBook cookBook;
    @RelatedTo(direction=Direction.INCOMING)
    @Fetch
    Ingredient secret;
    @RelatedTo(direction=Direction.INCOMING, type="secret")
    Set<Ingredient> secrets;

    Recipe() {
    }

    Recipe(String author, String title, Ingredient ingredient, Ingredient secret, CookBook cookBook) {
        this.author = author;
        this.title = title;
        this.ingredient = ingredient;
        this.secret = secret;
        this.cookBook = cookBook;
    }
}

