/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.repositories.FriendshipRepository;
import org.springframework.data.neo4j.repositories.GroupRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.repository.MemberDataPOJO;
import org.springframework.data.neo4j.repository.SerialTesters;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class SerializableGraphQueryRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    private SerialTesters serialTesters;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        this.serialTesters = new SerialTesters();
        this.serialTesters.createUpgraderTeam(this.personRepository, this.groupRepository, this.friendshipRepository);
    }

    @Test
    @Transactional
    public void shouldBeAbleToTurnQueryResultIntoAPOJO() throws Exception {
        MemberDataPOJO nickisMemberData = this.personRepository.findMemberDataPojo(this.serialTesters.nicki);
        this.assertPOJOContainsExpectedData(nickisMemberData);
    }

    @Test
    @Transactional
    public void shouldBeAbleToSerializedPOJOReturnedFromQueryResult() throws Exception {
        MemberDataPOJO nickisOrigMemberData = this.personRepository.findMemberDataPojo(this.serialTesters.nicki);
        this.assertPOJOContainsExpectedData(nickisOrigMemberData);
        Assert.assertThat((Object)nickisOrigMemberData, (Matcher)Matchers.instanceOf(Serializable.class));
        byte[] bos = this.serializeIt(nickisOrigMemberData);
        MemberDataPOJO nickisDeserMemberData = (MemberDataPOJO)this.deserializeIt(bos);
        this.assertPOJOContainsExpectedData(nickisDeserMemberData);
    }

    public void assertPOJOContainsExpectedData(MemberDataPOJO pojo) throws Exception {
        Assert.assertNotNull((Object)pojo);
        Assert.assertThat((Object)pojo.getBoss(), (Matcher)Matchers.is((Object)this.serialTesters.tareq));
        Assert.assertThat((Object)IteratorUtil.asCollection(pojo.getTeams()), (Matcher)Matchers.hasItem((Object)this.serialTesters.serialTesterGroup));
        Assert.assertThat((Object)pojo.getAnInt(), (Matcher)Matchers.is((Object)this.serialTesters.tareq.getAge()));
        Assert.assertThat((Object)pojo.getAName(), (Matcher)Matchers.is((Object)this.serialTesters.tareq.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> byte[] serializeIt(T someObject) throws Exception {
        try (ObjectOutputStream out = null;){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject(someObject);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deserializeIt(byte[] serializedBytes) throws Exception {
        try (ObjectInputStream in = null;){
            Object theNewObj;
            ByteArrayInputStream bis = new ByteArrayInputStream(serializedBytes);
            in = new ObjectInputStream(bis);
            Object object = theNewObj = in.readObject();
            return (T)object;
        }
    }
}

