/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.Personality;
import org.springframework.data.neo4j.repositories.FriendshipRepository;
import org.springframework.data.neo4j.repositories.GroupRepository;
import org.springframework.data.neo4j.repositories.PersonRepository;
import org.springframework.data.neo4j.repository.TestTeam;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/repository/GraphRepositoryTests-context.xml"})
@Transactional
public class SpatialGraphRepositoryTests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Neo4jTemplate neo4jTemplate;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    FriendshipRepository friendshipRepository;
    @Autowired
    PlatformTransactionManager transactionManager;
    private TestTeam testTeam;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb(this.neo4jTemplate);
    }

    @Before
    public void setUp() throws Exception {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SpatialGraphRepositoryTests.this.testTeam = new TestTeam();
                SpatialGraphRepositoryTests.this.testTeam.createSDGTeam(SpatialGraphRepositoryTests.this.personRepository, SpatialGraphRepositoryTests.this.groupRepository, SpatialGraphRepositoryTests.this.friendshipRepository);
            }
        });
    }

    @Test
    public void testFindPeopleWithinBoundingBox() {
        Result teamMembers = this.personRepository.findWithinBoundingBox("personLayer", 55.0, 15.0, 57.0, 17.0);
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinBoundingBoxShape() {
        Result teamMembers = this.personRepository.findWithinBoundingBox("personLayer", new Box(new Point(15.0, 55.0), new Point(17.0, 57.0)));
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinBoundingBoxShapeDerived() {
        Collection<Person> teamMembers = this.personRepository.findByWktWithin(new Box(new Point(15.0, 55.0), new Point(17.0, 57.0)));
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinPolygon() {
        Result teamMembers = this.personRepository.findWithinWellKnownText("personLayer", "POLYGON ((15 55, 15 57, 17 57, 17 55, 15 55))");
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinPolygonShape() {
        Result teamMembers = this.personRepository.findWithinShape("personLayer", (Shape)new Polygon(new Point(15.0, 55.0), new Point(15.0, 57.0), new Point(17.0, 57.0), new Point[]{new Point(17.0, 55.0)}));
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinPolygonShapeDerived() {
        Collection<Person> teamMembers = this.personRepository.findByWktWithinAndPersonality(new Polygon(new Point(15.0, 55.0), new Point(15.0, 57.0), new Point(17.0, 57.0), new Point[]{new Point(17.0, 55.0)}), Personality.EXTROVERT);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael}));
    }

    @Test
    public void testFindPeopleWithinDistance() {
        Result teamMembers = this.personRepository.findWithinDistance("personLayer", 56.0, 16.0, 70.0);
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinCircle() {
        Result teamMembers = this.personRepository.findWithinDistance("personLayer", new Circle(new Point(16.0, 56.0), new Distance(70.0, (Metric)Metrics.KILOMETERS)));
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david}));
    }

    @Test
    public void testFindPeopleNearCircleDerived() {
        Collection<Person> teamMembers = this.personRepository.findByWktNearAndName(new Circle(new Point(16.0, 56.0), new Distance(70.0, (Metric)Metrics.KILOMETERS)), "David");
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.contains((Object[])new Person[]{this.testTeam.david}));
    }

    @Test
    public void testFindPeopleWithinCircleDerived() {
        Collection<Person> teamMembers = this.personRepository.findByWktWithinAndAgeGreaterThan(new Circle(new Point(16.0, 56.0), new Distance(70.0, (Metric)Metrics.KILOMETERS)), 30);
        Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.contains((Object[])new Person[]{this.testTeam.michael}));
    }

    @Test
    @Ignore
    public void testPerformance() throws Exception {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 5000; ++i) {
            if (i % 1000 == 0) {
                long now = System.currentTimeMillis();
                System.out.println(i + ". entries " + (now - time));
                time = now;
            }
            Person person = new Person("John " + i, 40 + i);
            person.setLocation(i % 180 - 90, i % 180 - 90);
            this.personRepository.save(person);
        }
    }
}

