/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.Personality;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.template.Neo4jOperations;

public class TestTeam {
    public Person michael;
    public Person emil;
    public Person david;
    public Group sdg;
    public Friendship friendShip;

    public TestTeam createSDGTeam(GraphRepository<Person> repo, GraphRepository<Group> groupRepo, GraphRepository<Friendship> friendshipRepository) {
        this.emil = new Person("Emil", 30);
        this.emil.setAlias("emilAlias");
        this.michael = new Person("Michael", 36);
        this.michael.setBoss(this.emil);
        this.michael.setPersonality(Personality.EXTROVERT);
        this.michael.setLocation(16.0, 56.0);
        this.michael.setAlias("michaelAlias");
        this.david = new Person("David", 25);
        this.david.setAlias("davidAlias");
        this.david.setBoss(this.emil);
        this.david.setLocation(16.5, 56.5);
        this.friendShip = this.michael.knows(this.david);
        this.friendShip.setYears(2);
        this.sdg = new Group();
        this.sdg.setName("SDG");
        this.sdg.addPerson(this.michael);
        this.sdg.addPerson(this.emil);
        this.sdg.addPerson(this.david);
        repo.save(Arrays.asList(this.emil, this.david, this.michael));
        friendshipRepository.save((Object)this.friendShip);
        groupRepo.save((Object)this.sdg);
        return this;
    }

    public Map<String, Object> simpleRowFor(Person person, String prefix) {
        return MapUtil.map((Object[])new Object[]{prefix + ".name", person.getName(), prefix + ".age", person.getAge()});
    }

    public TestTeam createSDGTeam(Neo4jOperations template) {
        return this.createSDGTeam((GraphRepository<Person>)template.repositoryFor(Person.class), (GraphRepository<Group>)template.repositoryFor(Group.class), (GraphRepository<Friendship>)template.repositoryFor(Friendship.class));
    }
}

