/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.repository.query.AbstractDerivedFinderMethodTestBase;
import org.springframework.data.neo4j.repository.query.RepositoryQueryException;
import org.springframework.data.neo4j.support.typerepresentation.IndexBasedNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class DerivedFinderMethodForIndexedBasedTRSViaJavaConfigTests
extends AbstractDerivedFinderMethodTestBase {
    private static final String DEFAULT_START_CLAUSE = "START `thing`=node:__types__(className=\"Thing\")";
    @Autowired
    NodeTypeRepresentationStrategy strategy;

    @Override
    @Before
    public void setup() {
        super.setup();
        MatcherAssert.assertThat((String)"The tests in this class should be configured to use the Label based Type Representation Strategy, however it is not ... ", (Object)this.strategy, (Matcher)Matchers.instanceOf(IndexBasedNodeTypeRepresentationStrategy.class));
    }

    @Override
    @Test
    public void testQueryWithEntityGraphId() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing_owner`=node({0}) MATCH (`thing`)-[:`owner`]->(`thing_owner`) WHERE `thing`.__type__ IN ['Thing'] ";
        super.testQueryWithEntityGraphId();
    }

    @Override
    @Test
    public void testIndexQueryWithTwoParams() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:foo AND lastName:bar"};
        super.testIndexQueryWithTwoParams();
    }

    @Override
    @Test
    public void testIndexQueryWithOneParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`(`firstName`={0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"foo"};
        super.testIndexQueryWithOneParam();
    }

    @Override
    @Test
    public void testSchemaIndexQueryWithOneParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`alias` = {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"foo"};
        super.testSchemaIndexQueryWithOneParam();
    }

    @Override
    @Test
    public void testIndexQueryWithOneParamFullText() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`search`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"description:foo"};
        super.testIndexQueryWithOneParamFullText();
    }

    @Override
    @Test
    public void testIndexQueryWithOneParamFullTextAndOneParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`search`({0}) WHERE `thing`.`firstName` = {1} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"description:foo", "bar"};
        super.testIndexQueryWithOneParamFullTextAndOneParam();
    }

    @Override
    @Test
    public void testIndexQueryWithOneParamAndOneParamFullText() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`(`firstName`={0}) WHERE `thing`.`description` = {1} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"foo", "bar"};
        super.testIndexQueryWithOneParamAndOneParamFullText();
    }

    @Override
    @Test
    public void testIndexQueryWithOneNonIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`age` = {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{100};
        super.testIndexQueryWithOneNonIndexedParam();
    }

    @Override
    @Test
    public void testIndexQueryWithOneNonIndexedParamAndOneIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`(`firstName`={1}) WHERE `thing`.`age` = {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{100, "foo"};
        super.testIndexQueryWithOneNonIndexedParamAndOneIndexedParam();
    }

    @Override
    @Test
    public void testIndexQueryWithLikeIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:foo"};
        super.testIndexQueryWithLikeIndexedParam();
    }

    @Override
    @Test
    public void testIndexQueryWithLikeIndexedParamWithSpaces() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:\"foo bar\""};
        super.testIndexQueryWithLikeIndexedParamWithSpaces();
    }

    @Override
    @Test
    public void testIndexQueryWithContainsIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:*foo*"};
        super.testIndexQueryWithContainsIndexedParam();
    }

    @Override
    @Test
    public void testIndexQueryWithStartsWithIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:foo*"};
        super.testIndexQueryWithStartsWithIndexedParam();
    }

    @Override
    @Test
    public void testIndexQueryWithEndsWithIndexedParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"firstName:*foo"};
        super.testIndexQueryWithEndsWithIndexedParam();
    }

    @Override
    @Test(expected=RepositoryQueryException.class)
    public void testFailIndexQueryWithStartsWithIndexedParamWithSpaces() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`({0}) RETURN `thing`";
        super.testFailIndexQueryWithStartsWithIndexedParamWithSpaces();
    }

    @Override
    @Test
    public void testFindBySimpleStringParam() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` = {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"foo"};
        super.testFindBySimpleStringParam();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamStartsWith() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` =~ {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{"^foo.*"};
        super.testFindBySimpleStringParamStartsWith();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamEndsWith() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` =~ {0} RETURN `thing`";
        this.trsSpecificExpectedParams = new Object[]{".*foo$"};
        super.testFindBySimpleStringParamEndsWith();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamContains() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` =~ {0} RETURN `thing`";
        super.testFindBySimpleStringParamContains();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamLike() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` =~ {0} RETURN `thing`";
        super.testFindBySimpleStringParamLike();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamNotLike() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE not( `thing`.`name` =~ {0} ) RETURN `thing`";
        super.testFindBySimpleStringParamNotLike();
    }

    @Override
    @Test
    public void testFindBySimpleStringParamRegexp() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` =~ {0} RETURN `thing`";
        super.testFindBySimpleStringParamRegexp();
    }

    @Override
    @Test
    public void testFindBySimpleBooleanIsTrue() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`tagged` = true  RETURN `thing`";
        super.testFindBySimpleBooleanIsTrue();
    }

    @Override
    @Test
    public void testFindBySimpleBooleanIsFalse() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`tagged` = false  RETURN `thing`";
        super.testFindBySimpleBooleanIsFalse();
    }

    @Override
    @Test
    public void testFindBySimpleStringExists() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE has(`thing`.`name`  ) RETURN `thing`";
        super.testFindBySimpleStringExists();
    }

    @Override
    @Test
    public void testFindBySimpleStringInCollection() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` in {0} RETURN `thing`";
        super.testFindBySimpleStringInCollection();
    }

    @Override
    @Test
    public void testFindBySimpleStringInCollectionOfEnums() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`name` in {0} RETURN `thing`";
        super.testFindBySimpleStringInCollectionOfEnums();
    }

    @Override
    @Test
    public void testFindBySimpleStringNotInCollection() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE not( `thing`.`name` in {0} ) RETURN `thing`";
        super.testFindBySimpleStringNotInCollection();
    }

    @Override
    @Test
    public void testFindBySimpleDateBefore() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`born` < {0} RETURN `thing`";
        super.testFindBySimpleDateBefore();
    }

    @Override
    @Test
    public void testFindBySimpleDateAfter() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:__types__(className=\"Thing\") WHERE `thing`.`born` > {0} RETURN `thing`";
        super.testFindBySimpleDateAfter();
    }

    @Override
    @Test
    public void testFindByNumericIndexedField() throws Exception {
        this.trsSpecificExpectedQuery = "START `thing`=node:`Thing`(`number`={0}) RETURN `thing`";
        super.testFindByNumericIndexedField();
    }

    @Override
    @Test
    @Transactional
    public void testMultipleIndexedFields() throws Exception {
        super.testMultipleIndexedFields();
    }

    @Configuration
    @EnableNeo4jRepositories(basePackages={"org.springframework.data.neo4j.repository.query"})
    static class Config
    extends Neo4jConfiguration {
        Config() {
            this.setBasePackage(new String[]{"org.springframework.data.neo4j.model,org.springframework.data.neo4j.repository.query"});
        }

        public TypeRepresentationStrategyFactory typeRepresentationStrategyFactory() {
            return new TypeRepresentationStrategyFactory(this.graphDatabase(), TypeRepresentationStrategyFactory.Strategy.Indexed);
        }

        @Bean(name={"graphDatabaseService"}, destroyMethod="shutdown")
        public GraphDatabaseService graphDatabaseService() {
            return new TestGraphDatabaseFactory().newImpermanentDatabase();
        }
    }
}

